/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.util;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Xml {
    public static Element getTree(String xmlRootNodeName, String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new Exception("The file " + filePath + " does not exist.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document docApplication = builder.parse(file.toURI().toString());
        Element xmlNode = (Element)docApplication.getElementsByTagName(xmlRootNodeName).item(0);
        return xmlNode;
    }

    public static int loadScalarAsInteger(Element xmlRootNode, String scalarName) {
        int scalar = 0;
        Element xmlNode = (Element)xmlRootNode.getElementsByTagName(scalarName).item(0);
        scalar = Integer.valueOf(xmlNode.getAttribute("Value"));
        return scalar;
    }

    public static int[] loadArrayAsInteger(Element xmlRootNode, String arrayName) {
        Element xmlNode = (Element)xmlRootNode.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        int[] array = new int[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            int value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Integer.valueOf(xmlItem.getAttribute("Value")).intValue();
        }
        return array;
    }

    public static long[] loadArrayAsLong(Element xmlRootNode, String arrayName) {
        Element xmlNode = (Element)xmlRootNode.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        long[] array = new long[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            long value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Long.valueOf(xmlItem.getAttribute("Value")).longValue();
        }
        return array;
    }

    public static double[] loadArrayAsDouble(Element xmlRootNode, String arrayName) {
        Element xmlNode = (Element)xmlRootNode.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        double[] array = new double[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            double value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Double.valueOf(xmlItem.getAttribute("Value")).doubleValue();
        }
        return array;
    }

    public static long[][] loadMatrixAsLong(Element xmlRootNode, String matrixName) {
        Element xmlNode = (Element)xmlRootNode.getElementsByTagName(matrixName).item(0);
        int rows = Integer.valueOf(xmlNode.getAttribute("Rows"));
        int columns = Integer.valueOf(xmlNode.getAttribute("Columns"));
        long[][] matrix = new long[rows][columns];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < xmlItemList.getLength(); ++i) {
            long value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int row = Integer.valueOf(xmlItem.getAttribute("Row"));
            int column = Integer.valueOf(xmlItem.getAttribute("Column"));
            matrix[row][column] = value = Long.valueOf(xmlItem.getAttribute("Value")).longValue();
        }
        return matrix;
    }
}

