/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.dtlz;

import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.Variable;
import jeco.kernel.problem.VariableReal;
import jeco.lib.problems.dtlz.DTLZ;

public class DTLZ5
extends DTLZ {
    public DTLZ5(Integer numberOfVariables) {
        super("DTLZ5", numberOfVariables);
        for (int i = 0; i < numberOfVariables; ++i) {
            this.lowerBound[i] = 0.0;
            this.upperBound[i] = 1.0;
        }
    }

    public DTLZ5() {
        this(12);
    }

    public void evaluate(Solution solution) {
        int i;
        double[] theta = new double[this.numberOfObjectives];
        int k = this.numberOfVariables - this.numberOfObjectives + 1;
        double g = 0.0;
        Variable[] variables = solution.getVariables();
        for (int i2 = this.numberOfVariables - k + 1; i2 <= this.numberOfVariables; ++i2) {
            g += Math.pow((Double)((VariableReal)variables[i2 - 1]).getValue() - 0.5, 2.0);
        }
        double t = Math.PI / (4.0 * (1.0 + g));
        theta[0] = (Double)((VariableReal)variables[0]).getValue() * Math.PI / 2.0;
        for (i = 2; i <= this.numberOfObjectives - 1; ++i) {
            theta[i - 1] = t * (1.0 + 2.0 * g * (Double)((VariableReal)variables[i - 1]).getValue());
        }
        for (i = 1; i <= this.numberOfObjectives; ++i) {
            double f = 1.0 + g;
            for (int j = this.numberOfObjectives - i; j >= 1; --j) {
                f *= Math.cos(theta[j - 1]);
            }
            if (i > 1) {
                f *= Math.sin(theta[this.numberOfObjectives - i]);
            }
            solution.setObjective(i - 1, f);
        }
    }

    public Solutions computeParetoOptimalFront(int n) {
        int num = (int)Math.sqrt(n);
        Solutions result = new Solutions();
        for (int i = 0; i < num; ++i) {
            double x0 = 0.0 + 1.0 * (double)i / (double)(num - 1);
            for (int j = 0; j < num; ++j) {
                Solution sol = new Solution(this);
                double x1 = 0.0 + 1.0 * (double)j / (double)(num - 1);
                sol.getVariable(0).setValue(x0);
                sol.getVariable(1).setValue(x1);
                for (int k = 2; k < this.numberOfVariables; ++k) {
                    sol.getVariable(k).setValue(0.5);
                }
                this.evaluate(sol);
                result.add(sol);
            }
        }
        result.keepParetoNonDominated(new SolutionDominance());
        return result;
    }
}

