/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

public class Component {
    int id;
    String name;
    int type;
    int x;
    int y;
    int z;
    int l;
    int w;
    int h;
    double p;
    double dp;

    public Component(int id, String name, int type, int x, int y, int z, int l, int w, int h, double p) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.l = l;
        this.w = w;
        this.h = h;
        this.p = p;
        this.dp = p / (double)(l * w * h);
    }

    public Component(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Component(String validLineOfFile, int cellSize) {
        validLineOfFile = validLineOfFile.replaceAll("\t", " ");
        validLineOfFile = validLineOfFile.replaceAll("  ", " ");
        String[] parts = validLineOfFile.split(" ");
        int i = 0;
        this.id = Integer.valueOf(parts[i++]);
        this.name = parts[i++];
        this.type = this.name.startsWith("C") && this.name.length() <= 3 ? 0 : 1;
        this.z = Integer.valueOf(parts[i++]);
        this.x = Integer.valueOf(parts[i++]) / cellSize;
        this.y = Integer.valueOf(parts[i++]) / cellSize;
        this.l = Integer.valueOf(parts[i++]) / cellSize;
        this.w = Integer.valueOf(parts[i++]) / cellSize;
        this.h = 1;
        this.p = Double.valueOf(parts[i++]);
        double t = Double.valueOf(parts[i++]);
        this.dp = this.p / (double)(this.l * this.w * this.h);
    }

    public String toString() {
        if (this.id >= 0) {
            return "[" + this.name + "]";
        }
        return this.name;
    }

    public boolean equals(Object obj) {
        Component right = (Component)obj;
        if (right == null) {
            return false;
        }
        return this.id == right.id && this.name.equals(right.name);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.id;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public Component clone() {
        Component clone = new Component(this.id, this.name, this.type, this.x, this.y, this.z, this.l, this.w, this.h, this.p);
        clone.dp = this.dp;
        return clone;
    }
}

