/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jeco.lib.problems.floorplan.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FloorplanConfiguration {
    protected String filePath;
    protected int cellSize;
    protected int maxLength;
    protected int maxWidth;
    protected int maxHeight;
    protected HashMap<Integer, Component> components;
    protected HashMap<Integer, HashSet<Integer>> couplings;
    protected double[][][] temperatures;

    protected FloorplanConfiguration(String filePath) {
        this.filePath = filePath;
        this.components = new HashMap();
        this.couplings = new HashMap();
        try {
            this.load();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(FloorplanConfiguration.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FloorplanConfiguration.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(FloorplanConfiguration.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void load() throws ParserConfigurationException, IOException, SAXException {
        Component component;
        this.components.clear();
        this.couplings.clear();
        File file = new File(this.filePath);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmlDoc = builder.parse(file.toURI().toString());
        Element xmlRoot = xmlDoc.getDocumentElement();
        this.cellSize = Integer.valueOf(xmlRoot.getAttribute("CellSize"));
        this.maxLength = Integer.valueOf(xmlRoot.getAttribute("L"));
        this.maxWidth = Integer.valueOf(xmlRoot.getAttribute("W"));
        this.maxHeight = Integer.valueOf(xmlRoot.getAttribute("H"));
        this.temperatures = new double[this.maxLength][this.maxWidth][this.maxHeight];
        NodeList xmlBlockList = xmlDoc.getElementsByTagName("Block");
        for (int i = 0; i < xmlBlockList.getLength(); ++i) {
            Element xmlBlock = (Element)xmlBlockList.item(i);
            int id = Integer.valueOf(xmlBlock.getAttribute("id"));
            String name = xmlBlock.getAttribute("name");
            int type = Integer.valueOf(xmlBlock.getAttribute("type"));
            int x = Double.valueOf(xmlBlock.getAttribute("x")).intValue();
            int y = Double.valueOf(xmlBlock.getAttribute("y")).intValue();
            int z = Double.valueOf(xmlBlock.getAttribute("z")).intValue();
            int l = Double.valueOf(xmlBlock.getAttribute("l")).intValue();
            int w = Double.valueOf(xmlBlock.getAttribute("w")).intValue();
            int h = Double.valueOf(xmlBlock.getAttribute("h")).intValue();
            double p = Double.valueOf(xmlBlock.getAttribute("p"));
            Component component2 = new Component(id, name, type, x, y, z, l, w, h, p);
            this.components.put(component2.id, component2);
        }
        double maxDP = Double.MIN_VALUE;
        Iterator<Integer> itr = this.components.keySet().iterator();
        while (itr.hasNext()) {
            component = this.components.get(itr.next());
            if (!(maxDP < component.dp)) continue;
            maxDP = component.dp;
        }
        itr = this.components.keySet().iterator();
        while (itr.hasNext()) {
            component = this.components.get(itr.next());
            component.dp /= maxDP;
        }
        NodeList xmlCouplingList = xmlDoc.getElementsByTagName("Coupling");
        for (int i = 0; i < xmlCouplingList.getLength(); ++i) {
            Element xmlCoupling = (Element)xmlCouplingList.item(i);
            int idFrom = Integer.valueOf(xmlCoupling.getAttribute("idFrom"));
            int idTo = Integer.valueOf(xmlCoupling.getAttribute("idTo"));
            if (!this.couplings.containsKey(idFrom)) {
                this.couplings.put(idFrom, new HashSet());
            }
            this.couplings.get(idFrom).add(idTo);
        }
        NodeList xmlTemperatureList = xmlDoc.getElementsByTagName("Temperature");
        for (int i = 0; i < xmlTemperatureList.getLength(); ++i) {
            double temperature;
            Element xmlTemperature = (Element)xmlTemperatureList.item(i);
            int x = Integer.valueOf(xmlTemperature.getAttribute("x"));
            int y = Integer.valueOf(xmlTemperature.getAttribute("y"));
            int z = Integer.valueOf(xmlTemperature.getAttribute("z"));
            this.temperatures[x][y][z] = temperature = Double.valueOf(xmlTemperature.getAttribute("value")).doubleValue();
        }
    }
}

