/*
 * Decompiled with CFR 0.152.
 */
package moea.commons.comparator;

import java.util.Comparator;
import moea.commons.Entity;
import moea.commons.ObjectiveVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorEuclidean
implements Comparator<Entity> {
    protected static ComparatorEuclidean comparator = new ComparatorEuclidean();

    public static ComparatorEuclidean getInstance() {
        return comparator;
    }

    @Override
    public int compare(Entity left, Entity right) {
        double distanceLeft = 0.0;
        double distanceRight = 0.0;
        ObjectiveVector leftObj = left.getObjectiveVector();
        ObjectiveVector rightObj = right.getObjectiveVector();
        int nobj = Math.min(leftObj.size(), rightObj.size());
        for (int i = 0; i < nobj; ++i) {
            distanceLeft += (Double)leftObj.get(i) * (Double)leftObj.get(i);
            distanceRight += (Double)rightObj.get(i) * (Double)leftObj.get(i);
        }
        if (distanceLeft < distanceRight) {
            return -1;
        }
        if (distanceLeft > distanceRight) {
            return 1;
        }
        return 0;
    }
}

