/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.examples;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import moea.commons.Population;
import moea.moga.algorithms.Spea2;
import moea.moga.examples.Profile;
import moea.moga.genome.Chromosome;

public class ProfileMonoThreaded
extends Profile {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: ProfileMonoThreaded.jar ProFile PopSize[2048]");
            args = new String[]{"Physics.pro"};
            return;
        }
        String proPath = args[0];
        Integer[] popSizes = new Integer[]{1024, 512, 256};
        int maxGenerations = 8000;
        ProfileMonoThreaded.initializeProblem(proPath);
        BufferedWriter logger = new BufferedWriter(new FileWriter(new File("ProfileMonoThreaded.ts")));
        for (int i = 0; i < popSizes.length; ++i) {
            for (int j = 2; j <= 32; j += 2) {
                int popSize = popSizes[i] / j;
                Population<Chromosome> popIni = new Population<Chromosome>();
                for (int k = 0; k < popSize; ++k) {
                    ProfileMonoThreaded individual = new ProfileMonoThreaded();
                    popIni.add(individual);
                }
                Spea2 island = new Spea2("Island" + j, popIni, maxGenerations, 0.8, 0.01);
                double start = System.currentTimeMillis();
                island.start();
                island.join();
                double end = System.currentTimeMillis();
                logger.write(popSizes[i] + "\t" + j / 2 + "\t" + (end - start) / 1000.0 + "\n");
                logger.flush();
            }
        }
        logger.close();
    }
}

