/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.selector;

import java.util.Comparator;
import moea.commons.Entity;
import moea.commons.Population;
import moea.moga.genome.Chromosome;
import moea.moga.selector.TournamentSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VegaTournamentSelector
extends TournamentSelector {
    public VegaTournamentSelector(Comparator<Entity> comparator) {
        this(comparator, 2);
    }

    public VegaTournamentSelector(Comparator<Entity> comparator, int size) {
        super(comparator, size);
    }

    @Override
    public void update(Population<Chromosome> pop) {
        super.initialize(pop);
        int quota = this.poolSize / Chromosome.getN();
        for (int i = 0; i < this.poolSize; ++i) {
            int obj = i / quota;
            if (obj == Chromosome.getN()) {
                obj = (int)((double)Chromosome.getN() * Math.random());
            }
            this.generateTournament(pop, this.tournamentSize);
            Chromosome winner = (Chromosome)pop.get(this.tournament[0]);
            for (int j = 1; j < this.tournamentSize; ++j) {
                Chromosome currentIndividual = (Chromosome)pop.get(this.tournament[j]);
                double diff = (Double)winner.getObjectiveVector().get(obj) - (Double)currentIndividual.getObjectiveVector().get(obj);
                if (!(diff > 0.0)) continue;
                winner = currentIndividual;
            }
            this.pool[i] = winner;
        }
        this.currentIndex = 0;
    }
}

