/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import moea.commons.Population;
import moea.commons.assigner.AssignerNsga2;
import moea.commons.comparator.ComparatorPareto;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HNSPSO
extends MOPSO {
    AssignerNsga2<Particle> assigner = new AssignerNsga2();

    public HNSPSO(String name, Population<Particle> popIni, int maxT) {
        super(name, popIni, maxT);
    }

    public void assignParameters(Particle p) {
        double cd = p.getProperty("crowdingDistance") == null ? 0.0 : p.getProperty("crowdingDistance").doubleValue();
        double w = 0.7 * Math.exp(-cd) - 0.3 * (double)this.t / (double)this.maxT * Math.exp(-cd);
        double c1 = 2.5 - 2.0 * (double)this.t / (double)this.maxT;
        double c2 = 0.5 + 2.0 * (double)this.t / (double)this.maxT;
        p.setW(w);
        p.setC1(c1);
        p.setC2(c2);
    }

    public void reorder(Population<Particle> pop) {
        ArrayList<Population<Particle>> setsF = this.assigner.fastNonDominatedSort(pop);
        Population<Particle> setParent = setsF.get(0);
        if (setsF.size() == 1) {
            Population<Particle> pBests = new Population<Particle>();
            pBests.add(setParent);
            for (Particle p : setParent) {
                if (p.getPBest() == null) continue;
                pBests.add(p.getPBest());
            }
            Collections.sort(pBests, ComparatorPareto.getInstance());
            for (Particle p : setParent) {
                p.updateGBest((Particle)pBests.get((int)(Math.random() * (double)Particle.getN())));
            }
            return;
        }
        int sizeParent = 0;
        int sizeChild = 0;
        int ratio = 0;
        for (int i = 0; i < setsF.size(); ++i) {
            Population<Particle> setChild = setsF.get(i);
            sizeChild = setChild.size();
            if (i > 0 && (ratio = sizeChild / (sizeParent = (setParent = setsF.get(i - 1)).size())) == 0) {
                ratio = 1;
            }
            for (int j = 0; j < sizeChild; ++j) {
                Particle pChild = (Particle)setChild.get(j);
                if (i > 0) {
                    int p = j / ratio;
                    if (p < sizeParent) {
                        pChild.updateGBest((Particle)setParent.get(p));
                        continue;
                    }
                    pChild.updateGBest(null);
                    continue;
                }
                pChild.updateGBest(null);
            }
        }
    }

    @Override
    public void step() {
        Population childPop = new Population();
        for (Particle pTemp : this.pop) {
            childPop.add(pTemp.clone());
        }
        Particle p = null;
        double probMut = 1.0 / (double)Particle.getM();
        for (int i = 0; i < childPop.size(); ++i) {
            p = (Particle)childPop.get(i);
            this.assignParameters(p);
            p.updatePosition();
            p.updateVelocity();
            p.mutate(probMut);
            p.applyConstraints();
            p.updatePBest();
        }
        Population mixedPop = new Population();
        mixedPop.add(this.pop);
        mixedPop.add(childPop);
        this.pop = this.assigner.reduce(mixedPop, this.popSizeMax);
        this.reorder(this.pop);
        ++this.t;
    }
}

