/*
 * Decompiled with CFR 0.152.
 */
package algo.examples;

import algo.api.AbstractSolver;
import algo.api.Solution;
import algo.solvers.BreadthFirstSolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import moea.moga.examples.Profile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileSolution
implements Solution {
    public static final int AR = 0;
    public static final int ARP = 1;
    public static final int SLL = 2;
    public static final int DLL = 3;
    public static final int SLLO = 4;
    public static final int DLLO = 5;
    public static final int SLLAR = 6;
    public static final int DLLAR = 7;
    public static final int SLLARO = 8;
    public static final int DLLARO = 9;
    public static final String[] ddts = new String[]{"AR", "AR(P)", "SLL", "DLL", "SLL(O)", "DLL(O)", "SLL(AR)", "DLL(AR)", "SLL(ARO)", "DLL(ARO)"};
    protected static int varCount = 0;
    protected static String baseName = null;
    protected static String outDir = ".";
    protected static double cacheAccessTime;
    protected static double dramAccessTime;
    protected static double cacheLineSize;
    protected static double dramBandwith;
    protected static double cpuPower;
    protected static double cacheAccessEnergy;
    protected static double dramAccessPower;
    protected static long[] Ne;
    protected static double[] NeSd;
    protected static double[] Nve;
    protected static int Na;
    protected static double[] Nn;
    protected static int[] Te;
    protected static int Tref;
    protected static long[][] readsPerDdt;
    protected static long[][] writesPerDdt;
    protected static long[] readsPlusWritesPerDdt;
    protected static double[][] cacheMissesL1;
    protected ArrayList<Integer> ddtsSelected = new ArrayList();
    protected boolean objectiveValid;
    protected double objectiveValue;

    public static void initializeProblem() {
        cacheAccessTime = 1.0E-7;
        dramAccessTime = 1.0E-6;
        cacheLineSize = 32.0;
        dramBandwith = 5.0E7;
        cpuPower = 0.019;
        cacheAccessEnergy = 1.0E-4;
        dramAccessPower = 0.001;
        Element xmlProfileAnalyzer = null;
        try {
            File file = new File(outDir + File.separator + baseName + ".pro");
            if (!file.exists()) {
                throw new Exception("The file path does not exist.");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document docApplication = builder.parse(file.toURI().toString());
            xmlProfileAnalyzer = (Element)docApplication.getElementsByTagName("ProfileAnalyzer").item(0);
            varCount = ProfileSolution.loadScalarAsInteger(xmlProfileAnalyzer, "VarCount");
            Tref = ProfileSolution.loadScalarAsInteger(xmlProfileAnalyzer, "Tref");
            Na = ProfileSolution.loadScalarAsInteger(xmlProfileAnalyzer, "Na");
            Ne = ProfileSolution.loadArrayAsLong(xmlProfileAnalyzer, "Ne");
            NeSd = ProfileSolution.loadArrayAsDouble(xmlProfileAnalyzer, "NeSd");
            Nve = ProfileSolution.loadArrayAsDouble(xmlProfileAnalyzer, "Nve");
            Nn = ProfileSolution.loadArrayAsDouble(xmlProfileAnalyzer, "Nn");
            Te = ProfileSolution.loadArrayAsInteger(xmlProfileAnalyzer, "Te");
            readsPerDdt = ProfileSolution.loadMatrixAsLong(xmlProfileAnalyzer, "ReadsPerDdt");
            writesPerDdt = ProfileSolution.loadMatrixAsLong(xmlProfileAnalyzer, "WritesPerDdt");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        ProfileSolution.updateCacheMisses();
    }

    public static int loadScalarAsInteger(Element xmlProfileAnalyzer, String scalarName) {
        int scalar = 0;
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(scalarName).item(0);
        scalar = Integer.valueOf(xmlNode.getAttribute("Value"));
        return scalar;
    }

    public static int[] loadArrayAsInteger(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        int[] array = new int[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            int value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Integer.valueOf(xmlItem.getAttribute("Value")).intValue();
        }
        return array;
    }

    public static long[] loadArrayAsLong(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        long[] array = new long[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            long value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Long.valueOf(xmlItem.getAttribute("Value")).longValue();
        }
        return array;
    }

    public static double[] loadArrayAsDouble(Element xmlProfileAnalyzer, String arrayName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(arrayName).item(0);
        int size = Integer.valueOf(xmlNode.getAttribute("Size"));
        double[] array = new double[size];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < size; ++i) {
            double value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int index = Integer.valueOf(xmlItem.getAttribute("Index"));
            array[index] = value = Double.valueOf(xmlItem.getAttribute("Value")).doubleValue();
        }
        return array;
    }

    public static long[][] loadMatrixAsLong(Element xmlProfileAnalyzer, String matrixName) {
        Element xmlNode = (Element)xmlProfileAnalyzer.getElementsByTagName(matrixName).item(0);
        int rows = Integer.valueOf(xmlNode.getAttribute("Rows"));
        int columns = Integer.valueOf(xmlNode.getAttribute("Columns"));
        long[][] matrix = new long[rows][columns];
        NodeList xmlItemList = xmlNode.getElementsByTagName("Item");
        for (int i = 0; i < xmlItemList.getLength(); ++i) {
            long value;
            Element xmlItem = (Element)xmlItemList.item(i);
            int row = Integer.valueOf(xmlItem.getAttribute("Row"));
            int column = Integer.valueOf(xmlItem.getAttribute("Column"));
            matrix[row][column] = value = Long.valueOf(xmlItem.getAttribute("Value")).longValue();
        }
        return matrix;
    }

    public static void updateCacheMisses() {
        int j;
        int i;
        readsPlusWritesPerDdt = new long[Profile.ddts.length];
        for (i = 0; i < Profile.ddts.length; ++i) {
            ProfileSolution.readsPlusWritesPerDdt[i] = 0L;
        }
        for (i = 0; i < Profile.ddts.length; ++i) {
            for (j = 0; j < varCount; ++j) {
                int n = i;
                readsPlusWritesPerDdt[n] = readsPlusWritesPerDdt[n] + (readsPerDdt[j][i] + writesPerDdt[j][i]);
            }
        }
        cacheMissesL1 = new double[varCount][Profile.ddts.length];
        for (i = 0; i < varCount; ++i) {
            for (j = 0; j < Profile.ddts.length; ++j) {
                ProfileSolution.cacheMissesL1[i][j] = 1.0 * NeSd[i] * (double)readsPlusWritesPerDdt[j] / (double)(readsPlusWritesPerDdt[j] + readsPerDdt[i][j] + writesPerDdt[i][j]);
            }
        }
    }

    public ProfileSolution() {
        this.objectiveValid = false;
    }

    public ProfileSolution(ProfileSolution src, Integer newDdt) {
        for (Integer i : src.ddtsSelected) {
            this.ddtsSelected.add(i);
        }
        this.ddtsSelected.add(newDdt);
        this.objectiveValid = false;
    }

    @Override
    public ProfileSolution clone() {
        ProfileSolution clone = new ProfileSolution();
        clone.ddtsSelected = new ArrayList();
        for (Integer i : this.ddtsSelected) {
            clone.ddtsSelected.add(i);
        }
        clone.objectiveValid = this.objectiveValid;
        clone.objectiveValue = this.objectiveValue;
        return clone;
    }

    @Override
    public boolean isFeasible() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.ddtsSelected.size() == varCount;
    }

    @Override
    public double getObjective() {
        if (this.objectiveValid) {
            return this.objectiveValue;
        }
        double randomCount = 0.0;
        double secuentialCount = 0.0;
        double averageSize = 0.0;
        double numCreations = 0.0;
        double reads = 0.0;
        double writes = 0.0;
        double execTime = 0.0;
        double performance = 0.0;
        double memory = 0.0;
        double energy = 0.0;
        for (int i = 0; i < this.ddtsSelected.size(); ++i) {
            Integer ddt = this.ddtsSelected.get(i);
            if (ddt == null) continue;
            randomCount = 0.0;
            secuentialCount = 0.0;
            averageSize = 0.0;
            numCreations = 0.0;
            reads = readsPerDdt[i][ddt];
            writes = writesPerDdt[i][ddt];
            execTime = 0.0;
            if (ddt == 0) {
                secuentialCount = 9L * Ne[i];
                randomCount = 2.0;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)Te[i];
                numCreations = 1.0;
            } else if (ddt == 1) {
                secuentialCount = 10L * Ne[i];
                randomCount = 3.0;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)(Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 2) {
                secuentialCount = 7L * Ne[i];
                randomCount = Ne[i] / 2L + 1L;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)(2 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 3) {
                secuentialCount = 7L * Ne[i];
                randomCount = Ne[i] / 4L + 1L;
                averageSize = (long)(19 * Tref) + Ne[i] * (long)(3 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 4) {
                secuentialCount = 10L * Ne[i];
                randomCount = Ne[i] / 3L + 1L;
                averageSize = (long)(20 * Tref) + Ne[i] * (long)(2 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 5) {
                secuentialCount = 10L * Ne[i];
                randomCount = Ne[i] / 6L + 1L;
                averageSize = (long)(20 * Tref) + Ne[i] * (long)(3 * Tref + Te[i]);
                numCreations = 1.0 + Nve[i];
            } else if (ddt == 6) {
                secuentialCount = 18L * Ne[i] + (long)(8 * Na);
                randomCount = Nn[i] / 2.0 + 1.0;
                averageSize = (double)(21 * Tref) + Nn[i] * (double)((long)(21 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            } else if (ddt == 7) {
                secuentialCount = 18L * Ne[i] + (long)(8 * Na);
                randomCount = Nn[i] / 4.0 + 1.0;
                averageSize = (double)(21 * Tref) + Nn[i] * (double)((long)(22 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            } else if (ddt == 8) {
                secuentialCount = 18L * Ne[i] + (long)(10 * Na);
                randomCount = Nn[i] / 3.0 + 1.0;
                averageSize = (double)(22 * Tref) + Nn[i] * (double)((long)(21 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            } else if (ddt == 9) {
                secuentialCount = 18L * Ne[i] + (long)(10 * Na);
                randomCount = Nn[i] / 6.0 + 1.0;
                averageSize = (double)(22 * Tref) + Nn[i] * (double)((long)(22 * Tref) + Ne[i] * (long)(Te[i] + Tref));
                numCreations = (double)(2L * Ne[i]) + Nve[i];
            }
            performance += 1.0E-5 * (randomCount * (3.0 * (reads + writes - 2.0) / 4.0) + secuentialCount * ((reads + writes - 2.0) / 4.0) + 2.0 * numCreations);
            memory += averageSize;
            execTime = (reads + writes) * (1.0 - cacheMissesL1[i][ddt]) * cacheAccessTime + (reads + writes) * cacheMissesL1[i][ddt] * dramAccessTime + (reads + writes) * cacheMissesL1[i][ddt] * cacheLineSize * (1.0 / dramBandwith);
            energy += execTime * cpuPower + (reads + writes) * (1.0 - cacheMissesL1[i][ddt]) * cacheAccessEnergy + (reads + writes) * cacheMissesL1[i][ddt] * cacheAccessEnergy * cacheLineSize + (reads + writes) * cacheMissesL1[i][ddt] * dramAccessPower * (dramAccessTime + cacheLineSize / dramBandwith);
        }
        this.objectiveValue = performance + memory + energy;
        this.objectiveValid = true;
        return this.objectiveValue;
    }

    @Override
    public double getBound() {
        if (AbstractSolver.bestSolution == null) {
            return this.getObjective();
        }
        ProfileSolution bestSolution = ((ProfileSolution)AbstractSolver.bestSolution).clone();
        for (int i = 0; i < this.ddtsSelected.size(); ++i) {
            bestSolution.ddtsSelected.set(i, null);
            bestSolution.objectiveValid = false;
        }
        return this.getObjective() + bestSolution.getObjective();
    }

    @Override
    public Enumeration<Solution> getSuccessors() {
        Vector<ProfileSolution> succesors = new Vector<ProfileSolution>();
        for (int i = 0; i < ddts.length; ++i) {
            ProfileSolution solution = new ProfileSolution(this, i);
            if (!(solution.getObjective() < AbstractSolver.bestObjective)) continue;
            succesors.add(solution);
        }
        return succesors.elements();
    }

    @Override
    public int compareTo(Solution rhs) {
        double objRhs;
        double objLhs = this.getObjective();
        if (objLhs < (objRhs = rhs.getObjective())) {
            return -1;
        }
        if (objLhs == objRhs) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        String result = "";
        result = result + this.getObjective();
        for (int i = 0; i < varCount; ++i) {
            result = result + "\t" + this.ddtsSelected.get(i);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.print("XML basename (BASENAME.pro): ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        baseName = br.readLine();
        ProfileSolution.initializeProblem();
        for (int i = 0; i < 1; ++i) {
            System.out.println("Iteration number: " + i);
            ProfileSolution initialSolution = new ProfileSolution();
            BreadthFirstSolver solver = new BreadthFirstSolver();
            double start = System.currentTimeMillis();
            Solution solution = solver.solve(initialSolution);
            System.out.println("Final solution: " + solution.toString());
            double end = System.currentTimeMillis();
            System.out.println("Time: " + (end - start) / 1000.0);
            System.out.println("done.");
        }
    }
}

