/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm;

import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.Symbol;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import jeco.dmm.reliableDMM.AccessesManager;
import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMHeap;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.DMMProfileLine;
import jeco.dmm.simulator.layers.AbstractHeap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMMFitness
implements FitnessFunction {
    private static Logger logger = Logger.getLogger(DMMFitness.class.getName());
    protected String profilePath = "";
    protected String accessesPath = null;
    private static ArrayList<DMMProfileLine> profileLines = new ArrayList();

    public double evaluate(Phenotype phenotype) {
        double fitness = 0.0;
        DMMLogger.reset();
        DMMHeap.reset();
        AbstractHeap heap = this.composeHeap(phenotype);
        String nameHeap = this.toStringPhenotype(phenotype);
        logger.fine(nameHeap);
        this.simulate(heap);
        fitness = this.obtainFitness(18);
        return fitness;
    }

    public void getFitness(Individual individual) {
        individual.getFitness().setDouble(this.evaluate(individual.getPhenotype()));
    }

    public double obtainFitness(int option) {
        switch (option) {
            case 18: {
                double balancedInst = 1.0 * DMMLogger.getExecutionTimeReal();
                double balancedMemAcc = 1.0 * DMMLogger.getMemoryAccessesReal();
                double balancedMemUsed = 1.0 * (DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport());
                return balancedInst + balancedMemAcc + balancedMemUsed;
            }
            case 2: {
                return DMMLogger.getMemoryAccessesReal();
            }
            case 6: {
                return DMMLogger.getExecutionTimeReal();
            }
            case 3: {
                return DMMLogger.getMemoryUsedInHeap();
            }
            case 7: {
                return DMMLogger.getMemUsedByDMMSupport();
            }
            case 15: {
                return DMMLogger.getMemUsedByDMMSupport() + DMMLogger.getMemoryUsedInHeap();
            }
        }
        System.err.println("This case is not implemented by the fitness function");
        return Double.MAX_VALUE;
    }

    public boolean canCache() {
        return false;
    }

    public AbstractHeap composeHeap(Phenotype phenotype) {
        ArrayList<String> symbols = new ArrayList<String>();
        String symbol = null;
        for (int i = 0; i < phenotype.size(); ++i) {
            symbol = ((Symbol)phenotype.get(i)).getSymbolString();
            symbols.add(symbol);
        }
        Iterator<String> itr = symbols.iterator();
        AbstractHeap heap = null;
        try {
            String className = (String)itr.next();
            heap = (AbstractHeap)this.composeComplexObject(className, itr);
        }
        catch (Exception ee) {
            DMMLogger.addInfinity();
            System.err.println("DMMFitness: " + ee.getLocalizedMessage());
        }
        return heap;
    }

    public Object composeComplexObject(String currentSymbol, Iterator<String> itr) throws Exception {
        int i;
        Object object = null;
        String className = currentSymbol.substring(0, currentSymbol.length() - 1);
        Class<?> objectClass = Class.forName(className);
        Constructor<?>[] constructors = objectClass.getConstructors();
        String nextSymbol = itr.next();
        ArrayList<Object> parameters = this.composeParameters(nextSymbol, itr);
        for (i = 0; i < constructors.length && constructors[i].getParameterTypes().length != parameters.size(); ++i) {
        }
        Object[] parametersAsArray = new Object[parameters.size()];
        for (int j = 0; j < parameters.size(); ++j) {
            parametersAsArray[j] = parameters.get(j);
        }
        object = constructors[i].newInstance(parametersAsArray);
        return object;
    }

    public Object composeSimpleObject(String className) throws Exception {
        Integer object = null;
        try {
            Class<?> objectClass = Class.forName(className);
            object = objectClass.newInstance();
        }
        catch (ClassNotFoundException ee) {
            object = Integer.valueOf(className);
        }
        return object;
    }

    public ArrayList<Object> composeParameters(String currentSymbol, Iterator<String> itr) throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (currentSymbol.equals(",")) {
            currentSymbol = itr.next();
            parameters.addAll(this.composeParameters(currentSymbol, itr));
        } else if (!currentSymbol.equals(")")) {
            if (currentSymbol.endsWith("(")) {
                parameters.add(this.composeComplexObject(currentSymbol, itr));
                if (itr.hasNext()) {
                    currentSymbol = itr.next();
                    parameters.addAll(this.composeParameters(currentSymbol, itr));
                }
            } else {
                parameters.add(this.composeSimpleObject(currentSymbol));
                if (itr.hasNext()) {
                    currentSymbol = itr.next();
                    parameters.addAll(this.composeParameters(currentSymbol, itr));
                }
            }
        }
        return parameters;
    }

    public void simulate(AbstractHeap heap) {
        logger.fine("Running heap: " + heap.toString() + "...");
        long lineNumber = 0L;
        if (profileLines.size() == 0) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(new File(this.profilePath)));
                String line = reader.readLine();
                while (line != null) {
                    logger.fine(++lineNumber + " " + line);
                    DMMProfileLine currLine = new DMMProfileLine(lineNumber, line);
                    profileLines.add(currLine);
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception ee) {
                logger.severe(ee.getLocalizedMessage());
                DMMLogger.addInfinity();
            }
        }
        BufferedWriter writer = null;
        try {
            if (this.accessesPath != null) {
                writer = new BufferedWriter(new FileWriter(new File(this.accessesPath)));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        Iterator<DMMProfileLine> iterProfLines = profileLines.iterator();
        DMMProfileLine next = null;
        while (iterProfLines.hasNext()) {
            next = iterProfLines.next();
            DMMData dataObject = new DMMData(next.getDataId(), next.getDataSizeInBytes());
            String operation = next.getOperation();
            DMMBlock block = null;
            if (operation.equals("new")) {
                block = heap.malloc(dataObject);
                if (block == null) {
                    DMMLogger.addInfinity();
                    logger.warning("Impossible to allocate a block");
                    return;
                }
            } else if (operation.equals("delete")) {
                block = heap.free(dataObject);
            } else if (operation.equals("read") || operation.equals("write")) {
                block = DMMHeap.findBlock(dataObject.getId());
            }
            if (block != null) {
                block.setTime(next.getTime());
            }
            if (writer == null || block == null) continue;
            try {
                writer.write(block.getTime() + " " + block.getDataId() + "\n");
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public void runHeapOnProfile_AccessList_DEPRECATED(AbstractHeap heap, String profilePathAccesses, long limit, long numRegions) {
        logger.fine("Running heap: " + heap.toString() + "...");
        long lineNumber = 0L;
        String[] parts = null;
        String operation = null;
        String dataId = null;
        int dataSizeInBytes = 0;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(profilePathAccesses)));
            String[] temp = profilePathAccesses.split("\\.", 2);
            String outputPathTemp = temp[0] + ".AccessList";
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputPathTemp)));
            String line = reader.readLine();
            while (line != null) {
                DMMBlock block;
                logger.fine(++lineNumber + " " + line);
                parts = line.split(" ");
                operation = parts[0];
                dataId = parts[1];
                dataSizeInBytes = Integer.valueOf(parts[2]);
                DMMData dataObject = new DMMData(dataId, dataSizeInBytes);
                if (operation.equals("new")) {
                    block = heap.malloc(dataObject);
                    if (block == null) {
                        DMMLogger.addInfinity();
                        reader.close();
                        logger.warning("Impossible to allocate a block");
                        return;
                    }
                    writer.write(block.getAddress() + "\n");
                } else if (operation.equals("delete")) {
                    block = DMMHeap.findBlock(dataId);
                    writer.write(block.getAddress() + "\n");
                    heap.free(dataObject);
                } else if (operation.equals("read") || operation.equals("write")) {
                    block = DMMHeap.findBlock(dataId);
                    writer.write(block.getAddress() + "\n");
                }
                line = reader.readLine();
            }
            reader.close();
            writer.flush();
            writer.close();
            AccessesManager manager = new AccessesManager();
            double mem = DMMLogger.getMemoryUsedInHeap() + DMMLogger.getMemUsedByDMMSupport();
            manager.createFileAccesses(outputPathTemp, limit, mem, numRegions);
        }
        catch (Exception ee) {
            logger.severe(ee.getLocalizedMessage());
        }
    }

    public String toStringPhenotype(Phenotype phenotype) {
        String nameHeap = "";
        for (int i = 0; i < phenotype.size(); ++i) {
            nameHeap = nameHeap + ((Symbol)phenotype.get(i)).getSymbolString();
        }
        return nameHeap;
    }

    public void printResultsFitness(String nameAllocator, double fitnessReal) {
        System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        System.out.println(nameAllocator);
        System.out.println("\n");
        System.out.println("Fitness (Real): " + fitnessReal);
        DMMLogger.printRealInfo();
    }

    public void printResultsFitnessReal_Sim(String nameAllocator, double fitnessReal, double fitnessSim) {
        System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        System.out.println(nameAllocator);
        System.out.println("\n");
        System.out.println("Fitness (Sim): " + fitnessSim);
        System.out.println("Fitness (Real): " + fitnessReal);
        DMMLogger.printAllInfo();
    }

    public void setProperties(Properties p) {
        this.profilePath = p.getProperty("profile_path");
        this.accessesPath = p.getProperty("accesses_path");
    }
}

