/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib;

import FitnessEvaluation.FitnessFunction;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.Symbol;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.util.ManagersCreator;
import jeco.dmm.sim2.util.ProfilingReport;

public class Fitness
implements FitnessFunction {
    private static Logger logger = Logger.getLogger(Fitness.class.getName());
    public static HashMap<String, Double> evaluated = new HashMap();
    public static ProfilingReport profilingReport = null;

    public double evaluate(Phenotype phenotype) {
        String nameDMM = this.toStringPhenotype(phenotype);
        Double fitness = evaluated.get(nameDMM);
        if (fitness != null) {
            return fitness;
        }
        DynamicMemoryManager manager = ManagersCreator.buildManagerFromPhenotype(profilingReport, phenotype);
        Simulator simulator = new Simulator(profilingReport, manager);
        simulator.initialize();
        try {
            simulator.simulate();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        fitness = (double)(simulator.getMetrics().getExecutionTime() + simulator.getMetrics().getMemoryUsage()) + simulator.getMetrics().computeEnergy();
        evaluated.put(nameDMM, fitness);
        return fitness;
    }

    public void getFitness(Individual individual) {
        individual.getFitness().setDouble(this.evaluate(individual.getPhenotype()));
    }

    public boolean canCache() {
        return false;
    }

    public String toStringPhenotype(Phenotype phenotype) {
        StringBuffer nameHeap = new StringBuffer();
        for (int i = 0; i < phenotype.size(); ++i) {
            nameHeap.append(((Symbol)phenotype.get(i)).getSymbolString());
        }
        return nameHeap.toString();
    }

    public void setProperties(Properties p) {
    }
}

