/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.allocator.Allocator;
import jeco.dmm.sim2.lib.freelist.Block;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.Metrics;
import jeco.dmm.sim2.util.ProfilingReport;

public class Simulator
extends Thread {
    private static Logger logger = Logger.getLogger(Simulator.class.getName());
    protected ProfilingReport profilingReport;
    protected DynamicMemoryManager manager;
    protected Metrics metrics = null;
    protected String tracePath;

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Simulator(ProfilingReport profilingReport, DynamicMemoryManager manager, String tracePath) {
        this.profilingReport = profilingReport;
        this.manager = manager;
        this.tracePath = tracePath;
    }

    public Simulator(ProfilingReport profilingReport, DynamicMemoryManager manager) {
        this(profilingReport, manager, null);
    }

    public void initialize() {
        this.metrics = new Metrics();
        this.manager.blocksAllocated.clear();
        this.manager.currentPosition = 0L;
        this.manager.metrics = this.metrics;
        ArrayList<Allocator> allocators = this.manager.allocators;
        for (Allocator allocator : allocators) {
            allocator.setMetrics(this.metrics);
            for (FreeList adm : allocator.getFreeLists()) {
                adm.setMetrics(this.metrics);
                adm.getFreeBlocks().clear();
            }
        }
    }

    public void simulate() throws FileNotFoundException, IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Running simulation...");
        }
        this.metrics.setStartTime(System.currentTimeMillis());
        if (this.profilingReport.isAlive()) {
            logger.warning("The profiling report is still being loaded. Please, retry in a coupled of minutes.");
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.profilingReport.getPathToProfile())));
        long operationNumber = 0L;
        String line = reader.readLine();
        if (this.tracePath != null) {
            this.metrics.open(this.tracePath);
        }
        while (line != null) {
            if ((double)(++operationNumber) % 1000000.0 == 0.0) {
                logger.info("Processing operation number: " + operationNumber + " of " + this.profilingReport.getSize());
            }
            this.processLine(line);
            line = reader.readLine();
        }
        if (this.tracePath != null) {
            this.metrics.close();
        }
        this.metrics.setEndTime(System.currentTimeMillis());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("done.");
        }
    }

    protected void processLine(String line) throws IOException {
        double time = 0.0;
        String opcode = null;
        long objectId = 0L;
        long dataSizeInB = 0L;
        Block block = null;
        String[] parts = line.split(" ");
        time = Double.valueOf(parts[0]);
        opcode = parts[1];
        objectId = Long.valueOf(parts[2]);
        if (objectId < 0L) {
            return;
        }
        if (opcode.equals("new")) {
            dataSizeInB = Long.valueOf(parts[3]);
            if (dataSizeInB <= 0L) {
                return;
            }
            block = this.manager.malloc(objectId, dataSizeInB, null);
        } else if (opcode.equals("delete")) {
            block = this.manager.free(objectId);
        } else if (this.tracePath != null && (opcode.equals("read") || opcode.equals("write"))) {
            block = this.manager.blocksAllocated.get(objectId);
        }
        if (this.tracePath != null && block != null) {
            block.setTime(time);
            this.metrics.writeAccess(block.getTime() + " " + block.getPosition());
        }
    }

    public String drawAllocatorMap() {
        StringBuffer buffer = new StringBuffer();
        String simpleLine = "------------------------------------------------------------------\n";
        String doubleLine = "==================================================================\n";
        buffer.append("\n");
        for (Allocator allocator : this.manager.allocators) {
            buffer.append(doubleLine);
            buffer.append(allocator.getClass().getName());
            buffer.append(", split:" + allocator.isAllowSplitting());
            buffer.append(", coalesce:" + allocator.isAllowCoalescing() + "\n");
            for (FreeList freeList : allocator.getFreeLists()) {
                buffer.append(freeList.getDataStructure().toString());
                buffer.append("\t");
                buffer.append(freeList.getAllocationMechanism().toString());
                buffer.append("(");
                buffer.append(freeList.getAllocationPolicy().toString());
                buffer.append(")");
                buffer.append("\t");
                buffer.append("(" + freeList.getMinSizeInB() + "," + freeList.getMaxSizeInB() + "] B");
                buffer.append("\n");
            }
            buffer.append(doubleLine);
        }
        return buffer.toString();
    }

    public void run() {
        try {
            this.initialize();
            this.simulate();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

