/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.tools;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.TreeSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.Fitness;
import jeco.dmm.sim2.lib.Simulator;
import jeco.dmm.sim2.lib.allocator.BuddySystem;
import jeco.dmm.sim2.lib.allocator.ExactSegregatedFit;
import jeco.dmm.sim2.lib.allocator.Kingsley;
import jeco.dmm.sim2.lib.allocator.SegregatedFreeList;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.ManagersCreator;
import jeco.dmm.sim2.util.ProfilingReport;
import jeco.gui.util.MyFileFilter;
import jeco.gui.util.TextAreaOutputStream;
import jeco.kernel.algorithm.ge.GrammaticalEvolutionaryAlgorithm;
import jeco.kernel.util.LoggerFormatter;

public class SimulatorWin
extends JFrame {
    private static Logger logger = Logger.getLogger(SimulatorWin.class.getName());
    protected ProfilingReport profilingReport = null;
    protected DynamicMemoryManager manager = null;
    protected File currentDirectory;
    private JButton clearButton;
    private JButton defaultsButton;
    private JComboBox dmmSelector;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JButton loadProfile;
    private JTextArea logArea;
    private JComboBox logLevel;
    private JTextField logPath;
    private JTextField mapPath;
    private JTextField metrPath;
    private JButton newLog;
    private JButton newMap;
    private JButton newMetric;
    private JTextField profPath;
    private JButton runButton;

    public SimulatorWin() {
        this.initComponents();
        PrintStream stream = new PrintStream(new TextAreaOutputStream(this.logArea));
        System.setOut(stream);
        System.setErr(stream);
        this.logLevel.setSelectedIndex(5);
        this.dmmSelector.setSelectedIndex(0);
        this.currentDirectory = new File(".");
        this.updateLogLevel();
    }

    private File showSaveDialog(String extension, String description) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(this.currentDirectory);
        MyFileFilter filter = new MyFileFilter();
        filter.addExtension(extension);
        filter.setDescription(description);
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        File file = fc.getSelectedFile();
        if (file != null) {
            this.currentDirectory = fc.getCurrentDirectory();
        }
        return file;
    }

    private void updateLogLevel() {
        Level[] level = new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.OFF, Level.SEVERE, Level.WARNING};
        int i = this.logLevel.getSelectedIndex();
        LogManager.getLogManager().getLogger("").setLevel(level[i]);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            handlers[index].setLevel(level[i]);
            handlers[index].setFormatter(LoggerFormatter.formatter);
        }
    }

    private void initComponents() {
        this.profPath = new JTextField();
        this.loadProfile = new JButton();
        this.jLabel1 = new JLabel();
        this.logLevel = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.logArea = new JTextArea();
        this.runButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.metrPath = new JTextField();
        this.newMetric = new JButton();
        this.jLabel4 = new JLabel();
        this.mapPath = new JTextField();
        this.newMap = new JButton();
        this.jLabel5 = new JLabel();
        this.logPath = new JTextField();
        this.newLog = new JButton();
        this.jLabel6 = new JLabel();
        this.dmmSelector = new JComboBox();
        this.defaultsButton = new JButton();
        this.clearButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.loadProfile.setText("Load ...");
        this.loadProfile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.loadProfileActionPerformed(evt);
            }
        });
        this.jLabel1.setText("LOG LEVEL:");
        this.logLevel.setModel(new DefaultComboBoxModel<String>(new String[]{"ALL", "CONFIG", "FINE", "FINER", "FINEST", "INFO", "OFF", "SEVERE", "WARNING"}));
        this.logLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.logLevelActionPerformed(evt);
            }
        });
        this.logArea.setColumns(20);
        this.logArea.setFont(new Font("Courier New", 0, 10));
        this.logArea.setRows(5);
        this.jScrollPane1.setViewportView(this.logArea);
        this.runButton.setText("Run ...");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.runButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Profiling Report:");
        this.jLabel3.setText("Metrics:");
        this.newMetric.setText("New ...");
        this.newMetric.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.newMetricActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Map:");
        this.newMap.setText("New ...");
        this.newMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.newMapActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Log Accesses:");
        this.logPath.setToolTipText("Leave blank if you do not want to save accesses (the simulator will perform better).");
        this.newLog.setText("New ...");
        this.newLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.newLogActionPerformed(evt);
            }
        });
        this.jLabel6.setText("DMM:");
        this.dmmSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Kingsley", "Lea", "Fibonacci", "Segregated10", "Exact", "GE"}));
        this.dmmSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.dmmSelectorActionPerformed(evt);
            }
        });
        this.defaultsButton.setText("Auto Fill");
        this.defaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.defaultsButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorWin.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 490, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.logPath, -1, 331, Short.MAX_VALUE).addComponent(this.profPath, GroupLayout.Alignment.TRAILING, -1, 331, Short.MAX_VALUE).addComponent(this.metrPath, -1, 331, Short.MAX_VALUE).addComponent(this.mapPath, -1, 331, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.newLog, -1, -1, Short.MAX_VALUE).addComponent(this.newMap, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.newMetric, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.loadProfile, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.dmmSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultsButton, -2, 79, -2).addGap(6, 6, 6).addComponent(this.runButton, -2, 79, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton, -2, 79, -2)).addComponent(this.logLevel, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.profPath, -2, -1, -2).addComponent(this.loadProfile).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.metrPath, -2, -1, -2).addComponent(this.newMetric).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mapPath, -2, -1, -2).addComponent(this.newMap).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.logPath, -2, -1, -2).addComponent(this.newLog).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.logLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.dmmSelector, -2, -1, -2).addComponent(this.defaultsButton).addComponent(this.runButton).addComponent(this.clearButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 183, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void loadProfileActionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        Container c = button.getParent();
        while (!c.getClass().getName().equals(SimulatorWin.class.getName())) {
            c = c.getParent();
        }
        SimulatorWin mainWin = (SimulatorWin)c;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(this.currentDirectory);
        MyFileFilter filter = new MyFileFilter();
        filter.addExtension("mem");
        filter.setDescription("MEM File");
        fc.setFileFilter(filter);
        fc.showOpenDialog(mainWin);
        File file = fc.getSelectedFile();
        if (file != null && file.exists()) {
            this.currentDirectory = fc.getCurrentDirectory();
            mainWin.profPath.setText(file.getAbsolutePath());
        }
        if (this.profilingReport != null) {
            this.profilingReport.stopReading();
            try {
                this.profilingReport.join();
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        this.profilingReport = new ProfilingReport(this.profPath.getText());
        this.profilingReport.start();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.profilingReport.isAlive()) {
                logger.warning("The profiling report is still being loaded.");
                return;
            }
            logger.info("Min size: " + this.profilingReport.getMinSizeInB() + "B");
            logger.info("Max size: " + this.profilingReport.getMaxSizeInB() + "B");
            Simulator simulator = null;
            simulator = !this.logPath.getText().isEmpty() ? new Simulator(this.profilingReport, this.manager, this.logPath.getText()) : new Simulator(this.profilingReport, this.manager);
            simulator.start();
            simulator.join();
            String mapAsString = simulator.drawAllocatorMap();
            String reportAsString = simulator.getMetrics().report();
            logger.info(mapAsString);
            logger.info(reportAsString);
            BufferedWriter writer = null;
            if (!this.mapPath.getText().isEmpty()) {
                logger.info("Saving map ...");
                writer = new BufferedWriter(new FileWriter(new File(this.mapPath.getText())));
                writer.write(mapAsString);
                writer.flush();
                writer.close();
            }
            if (!this.metrPath.getText().isEmpty()) {
                logger.info("Saving metrics ...");
                writer = new BufferedWriter(new FileWriter(new File(this.metrPath.getText())));
                writer.write(reportAsString);
                writer.flush();
                writer.close();
            }
            logger.info("DONE.");
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void newMetricActionPerformed(ActionEvent evt) {
        File file = this.showSaveDialog("mtr", "Metric File");
        if (file != null) {
            this.metrPath.setText(file.getAbsolutePath());
        }
    }

    private void newMapActionPerformed(ActionEvent evt) {
        File file = this.showSaveDialog("map", "Map File");
        if (file != null) {
            this.mapPath.setText(file.getAbsolutePath());
        }
    }

    private void newLogActionPerformed(ActionEvent evt) {
        File file = this.showSaveDialog("acc", "Accesses File");
        if (file != null) {
            this.logPath.setText(file.getAbsolutePath());
        }
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        String profilePath = this.profPath.getText();
        if (profilePath.isEmpty()) {
            return;
        }
        String baseName = null;
        int pos = profilePath.lastIndexOf(".mem");
        baseName = pos < 0 ? profilePath : profilePath.substring(0, pos);
        baseName = baseName + "." + this.dmmSelector.getSelectedItem().toString();
        this.metrPath.setText(baseName + ".mtr");
        this.mapPath.setText(baseName + ".map");
        this.logPath.setText(baseName + ".acc");
    }

    private void logLevelActionPerformed(ActionEvent evt) {
        this.updateLogLevel();
    }

    private void dmmSelectorActionPerformed(ActionEvent evt) {
        if (this.dmmSelector.getSelectedIndex() == 0) {
            this.manager = new DynamicMemoryManager(new Kingsley());
        } else if (this.dmmSelector.getSelectedIndex() == 1) {
            logger.severe("LEA allocator has not been implemented yet.");
        } else if (this.dmmSelector.getSelectedIndex() == 2) {
            BuddySystem fibonacci = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, this.profilingReport.getMaxSizeInB(), false, false);
            fibonacci.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            this.manager = new DynamicMemoryManager(fibonacci);
        } else if (this.dmmSelector.getSelectedIndex() == 3) {
            SegregatedFreeList segregated = new SegregatedFreeList(0L, this.profilingReport.getMaxSizeInB(), false, false);
            ManagersCreator.buildSeveralFreeLists(10, segregated, FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            this.manager = new DynamicMemoryManager(segregated);
        } else if (this.dmmSelector.getSelectedIndex() == 4) {
            ExactSegregatedFit exact = new ExactSegregatedFit(0L, this.profilingReport.getMaxSizeInB(), this.profilingReport.getSizesInB());
            exact.setup(FreeList.DATA_STRUCTURE.DLL, FreeList.ALLOCATION_MECHANISM.FIRST, FreeList.ALLOCATION_POLICY.FIFO);
            this.manager = new DynamicMemoryManager(exact);
        } else if (this.dmmSelector.getSelectedIndex() == 5) {
            String profilePath = this.profPath.getText();
            if (profilePath.isEmpty()) {
                return;
            }
            String baseName = null;
            int pos = profilePath.lastIndexOf(".mem");
            baseName = pos < 0 ? profilePath : profilePath.substring(0, pos);
            baseName = baseName + "." + this.dmmSelector.getSelectedItem().toString();
            String grammarPath = baseName + ".bnf";
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(grammarPath)));
                writer.write("<DynamicMemoryManager> ::= <Allocators>\n");
                writer.write("<Allocators> ::= <AllocatorMaxSize>|<AllocatorSize>\n");
                writer.write("<AllocatorSize> ::= <AllocatorClass><AllowSplitting><AllowCoalescing><Size><DataStructure><AllocationMechanism><AllocationPolicy><Allocators>\n");
                writer.write("<AllocatorMaxSize> ::= <AllocatorClass><AllowSplitting><AllowCoalescing><MaxSize><DataStructure><AllocationMechanism><AllocationPolicy>\n");
                writer.write("<AllocatorClass> ::= SegregatedFreeList|SimpleSegregatedStorage|ExactSegregatedFit|BuddySystemBinary|BuddySystemFibonacci\n");
                writer.write("<Size> ::= ");
                TreeSet<Long> sizes = this.profilingReport.getSizesInB();
                boolean first = true;
                for (Long size : sizes) {
                    if (size.longValue() == this.profilingReport.getMaxSizeInB()) continue;
                    if (first) {
                        first = false;
                    } else {
                        writer.write("|");
                    }
                    writer.write("" + size);
                }
                writer.write("\n");
                writer.write("<MaxSize> ::= " + this.profilingReport.getMaxSizeInB() + "\n");
                writer.write("<AllowSplitting> ::= true|false\n");
                writer.write("<AllowCoalescing> ::= true|false\n");
                writer.write("<DataStructure> ::= SLL|DLL|BTREE\n");
                writer.write("<AllocationMechanism> ::= FIRST|BEST|EXACT\n");
                writer.write("<AllocationPolicy> ::= FIFO|LIFO\n");
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SimulatorWin.class.getName()).log(Level.SEVERE, null, ex);
            }
            Fitness.evaluated.clear();
            Fitness.profilingReport = this.profilingReport;
            GrammaticalEvolutionaryAlgorithm optimizer = new GrammaticalEvolutionaryAlgorithm(grammarPath, Fitness.class.getName());
            optimizer.setProperty("generations", "100");
            optimizer.setProperty("population_size", "60");
            optimizer.setProperty("max_depth", "10");
            optimizer.setProperty("mutation_probability", "0.02");
            optimizer.setProperty("crossover_probability", "0.8");
            logger.info("Initializing gramatical evolution...\n");
            optimizer.initialize();
            logger.info("Executing gramatical evolution...\n");
            optimizer.execute();
            logger.info("done.\n");
            this.manager = ManagersCreator.buildManagerFromPhenotype(this.profilingReport, optimizer.getBestFitness().getIndividual().getPhenotype());
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.logArea.setText("");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SimulatorWin test = new SimulatorWin();
                test.setTitle("DMM Simulator test");
                test.setVisible(true);
            }
        });
    }
}

