/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.sim2.util;

import Individuals.Phenotype;
import Mapper.Symbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import jeco.dmm.sim2.lib.DynamicMemoryManager;
import jeco.dmm.sim2.lib.allocator.Allocator;
import jeco.dmm.sim2.lib.allocator.BuddySystem;
import jeco.dmm.sim2.lib.allocator.ExactSegregatedFit;
import jeco.dmm.sim2.lib.allocator.SegregatedFreeList;
import jeco.dmm.sim2.lib.allocator.SimpleSegregatedStorage;
import jeco.dmm.sim2.lib.freelist.FreeList;
import jeco.dmm.sim2.util.ProfilingReport;

public class ManagersCreator {
    public static void buildSeveralFreeLists(int n, SegregatedFreeList allocator, FreeList.DATA_STRUCTURE dataStructure, FreeList.ALLOCATION_MECHANISM fitAlgorithm, FreeList.ALLOCATION_POLICY policy) {
        long currSizeInB;
        if (n <= 0) {
            return;
        }
        if (n == 1) {
            allocator.add(new FreeList(dataStructure, fitAlgorithm, policy, allocator.getMinSizeInB(), allocator.getMaxSizeInB()));
            return;
        }
        long minSizeInB = allocator.getMinSizeInB();
        long maxSizeInB = allocator.getMaxSizeInB();
        long stepSizeInB = (long)Math.ceil(1.0 * (double)(maxSizeInB - minSizeInB) / (double)n);
        long prevSizeInB = minSizeInB;
        FreeList freeList = null;
        for (long i = 0L; i < (long)n && ((currSizeInB = minSizeInB + (i + 1L) * stepSizeInB) <= maxSizeInB || prevSizeInB != (currSizeInB = maxSizeInB)); ++i) {
            freeList = new FreeList(dataStructure, fitAlgorithm, policy, prevSizeInB, currSizeInB);
            allocator.add(freeList);
            prevSizeInB = currSizeInB;
        }
    }

    public static DynamicMemoryManager buildManagerFromPhenotype(ProfilingReport report, Phenotype phenotype) {
        DynamicMemoryManager manager = new DynamicMemoryManager();
        LinkedList<String> symbols = new LinkedList<String>();
        String symbol = null;
        for (int i = 0; i < phenotype.size(); ++i) {
            symbol = ((Symbol)phenotype.get(i)).getSymbolString();
            symbols.add(symbol);
        }
        String allocatorClass = null;
        String dataStructure = null;
        String allocationMechanism = null;
        String allocationPolicy = null;
        boolean allowSplitting = false;
        boolean allowCoalescing = false;
        long maxSizeInB = 0L;
        Allocator allocator = null;
        Iterator itr = symbols.iterator();
        while (itr.hasNext()) {
            allocatorClass = (String)itr.next();
            allowSplitting = Boolean.valueOf((String)itr.next());
            allowCoalescing = Boolean.valueOf((String)itr.next());
            maxSizeInB = Long.valueOf((String)itr.next());
            dataStructure = (String)itr.next();
            allocationMechanism = (String)itr.next();
            allocationPolicy = (String)itr.next();
            if (allocatorClass.equals("SegregatedFreeList")) {
                allocator = new SegregatedFreeList(0L, maxSizeInB, allowSplitting, allowCoalescing);
            } else if (allocatorClass.equals("SimpleSegregatedStorage")) {
                allocator = new SimpleSegregatedStorage(0L, maxSizeInB);
            } else if (allocatorClass.equals("ExactSegregatedFit")) {
                allocator = new ExactSegregatedFit(0L, maxSizeInB, report.getSizesInB());
            } else if (allocatorClass.equals("BuddySystemBinary")) {
                allocator = new BuddySystem(BuddySystem.TYPE.BINARY, 0L, maxSizeInB, allowSplitting, allowCoalescing);
            } else if (allocatorClass.equals("BuddySystemFibonacci")) {
                allocator = new BuddySystem(BuddySystem.TYPE.FIBONACCI, 0L, maxSizeInB, allowSplitting, allowCoalescing);
            }
            manager.add(allocator);
        }
        manager.sortAndFixMinSizes();
        itr = symbols.iterator();
        while (itr.hasNext()) {
            allocatorClass = (String)itr.next();
            allowSplitting = Boolean.valueOf((String)itr.next());
            allowCoalescing = Boolean.valueOf((String)itr.next());
            maxSizeInB = Long.valueOf((String)itr.next());
            dataStructure = (String)itr.next();
            allocationMechanism = (String)itr.next();
            allocationPolicy = (String)itr.next();
            ArrayList<Allocator> allocators = manager.getAllocators();
            for (Allocator allocatorTemp : allocators) {
                if (!allocatorTemp.canManage(maxSizeInB)) continue;
                allocator = allocatorTemp;
                break;
            }
            if (allocatorClass.equals("SegregatedFreeList")) {
                ManagersCreator.buildSeveralFreeLists(allocators.size(), allocator, FreeList.DATA_STRUCTURE.valueOf(dataStructure), FreeList.ALLOCATION_MECHANISM.valueOf(allocationMechanism), FreeList.ALLOCATION_POLICY.valueOf(allocationPolicy));
                continue;
            }
            ((Allocator)allocator).setup(FreeList.DATA_STRUCTURE.valueOf(dataStructure), FreeList.ALLOCATION_MECHANISM.valueOf(allocationMechanism), FreeList.ALLOCATION_POLICY.valueOf(allocationPolicy));
        }
        return manager;
    }
}

