/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.simulator.layers.coalescing;

import java.util.logging.Logger;
import jeco.dmm.simulator.DMMBlock;
import jeco.dmm.simulator.DMMData;
import jeco.dmm.simulator.DMMLogger;
import jeco.dmm.simulator.headers.LeaHeader;
import jeco.dmm.simulator.layers.AbstractHeap;

public class CoalesceableHeap
extends AbstractHeap {
    private static Logger logger = Logger.getLogger(CoalesceableHeap.class.getName());
    protected AbstractHeap child;

    public CoalesceableHeap(AbstractHeap child) {
        super(child.getHeader());
        DMMLogger.updateData(2L, 5L, 1L, 0L);
        DMMLogger.addMemUsedByDMMSupport(1L);
        this.child = child;
    }

    public DMMBlock free(DMMData dataObject) {
        logger.fine(this.getClass().getCanonicalName() + "::free");
        System.err.println(this.getClass().getSimpleName() + "::free --> I think is not allowed to reach this point");
        DMMLogger.addInfinity();
        return this.child.free(dataObject);
    }

    public DMMBlock malloc(DMMData dataObject) {
        DMMLogger.updateData(2L, 5L, 0L, 1L);
        DMMBlock block = this.child.malloc(dataObject);
        if (block == null) {
            DMMLogger.updateData(1L, 1L, 0L, 0L);
            return block;
        }
        DMMLogger.updateData(7L, 19L, 0L, 0L);
        LeaHeader header = (LeaHeader)block.getHeader();
        header.setMmapped(false);
        LeaHeader nextHeader = (LeaHeader)block.getNextInHeap().getHeader();
        LeaHeader nextOfNextHeader = (LeaHeader)block.getNextInHeap().getNextInHeap().getHeader();
        nextHeader.setDataSize(0L);
        nextOfNextHeader.setPrevUsed(true);
        return block;
    }

    public boolean remove(DMMData dataObject) {
        System.err.println("Error remove CoalesceableHeap");
        DMMLogger.addInfinity();
        return false;
    }
}

