/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.assigner;

import java.util.Collections;
import jeco.kernel.operator.comparator.ObjectiveComparator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.Distance;

public class NicheCount {
    protected int numberOfObjectives;
    public static final String propertyNicheCount = "nicheCount";

    public NicheCount(int numberOfObjectives) {
        this.numberOfObjectives = numberOfObjectives;
    }

    public Solutions execute(Solutions solutions) {
        int size = solutions.size();
        if (size == 0) {
            return solutions;
        }
        if (size == 1) {
            ((Solution)solutions.get(0)).setProperty(propertyNicheCount, 0);
            return solutions;
        }
        for (int i = 0; i < size; ++i) {
            ((Solution)solutions.get(i)).setProperty(propertyNicheCount, 0);
        }
        double sigmaShare = 0.0;
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            Collections.sort(solutions, new ObjectiveComparator(i));
            double minObjective = ((Solution)solutions.get(0)).getObjective(i);
            double maxObjective = ((Solution)solutions.get(size - 1)).getObjective(i);
            sigmaShare += maxObjective - minObjective;
        }
        sigmaShare /= (double)(size - 1);
        for (int i = 0; i < size; ++i) {
            Solution solI = (Solution)solutions.get(i);
            for (int j = 0; j < size; ++j) {
                Solution solJ;
                double distanceIJ;
                if (i == j || !((distanceIJ = Distance.euclideanDistance(solI, solJ = (Solution)solutions.get(j))) < sigmaShare)) continue;
                solI.setProperty(propertyNicheCount, solI.getProperty(propertyNicheCount).intValue() + 1);
            }
        }
        return solutions;
    }
}

