/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.crossover;

import jeco.kernel.operator.crossover.CrossoverOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.VariableReal;
import jeco.kernel.util.RandomGenerator;

public class SBXCrossover
extends CrossoverOperator {
    public static final double DEFAULT_ETA_C = 20.0;
    public static final double DEFAULT_PROBABILITY = 0.9;
    private static final double EPS = 1.0E-14;
    protected double eta_c;
    protected double probability;

    public SBXCrossover() {
        this.eta_c = 20.0;
        this.probability = 0.9;
    }

    public SBXCrossover(double eta_c, double probability) {
        this.eta_c = eta_c;
        this.probability = probability;
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) {
        Solution[] offSpring = new Solution[]{parent1.clone(), parent2.clone()};
        if (RandomGenerator.nextDouble() <= probability) {
            for (int i = 0; i < parent1.getVariables().length; ++i) {
                double valueX1 = (Double)((VariableReal)parent1.getVariable(i)).getValue();
                double valueX2 = (Double)((VariableReal)parent2.getVariable(i)).getValue();
                if (RandomGenerator.nextDouble() <= 0.5) {
                    if (Math.abs(valueX1 - valueX2) > 1.0E-14) {
                        double y2;
                        double y1;
                        if (valueX1 < valueX2) {
                            y1 = valueX1;
                            y2 = valueX2;
                        } else {
                            y1 = valueX2;
                            y2 = valueX1;
                        }
                        double yL = (Double)((VariableReal)parent1.getVariable(i)).getLowerBound();
                        double yU = (Double)((VariableReal)parent1.getVariable(i)).getUpperBound();
                        double rand = RandomGenerator.nextDouble();
                        double beta = 1.0 + 2.0 * (y1 - yL) / (y2 - y1);
                        double alpha = 2.0 - Math.pow(beta, -(this.eta_c + 1.0));
                        double betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.eta_c + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.eta_c + 1.0));
                        double c1 = 0.5 * (y1 + y2 - betaq * (y2 - y1));
                        beta = 1.0 + 2.0 * (yU - y2) / (y2 - y1);
                        alpha = 2.0 - Math.pow(beta, -(this.eta_c + 1.0));
                        betaq = rand <= 1.0 / alpha ? Math.pow(rand * alpha, 1.0 / (this.eta_c + 1.0)) : Math.pow(1.0 / (2.0 - rand * alpha), 1.0 / (this.eta_c + 1.0));
                        double c2 = 0.5 * (y1 + y2 + betaq * (y2 - y1));
                        if (c1 < yL) {
                            c1 = yL;
                        }
                        if (c2 < yL) {
                            c2 = yL;
                        }
                        if (c1 > yU) {
                            c1 = yU;
                        }
                        if (c2 > yU) {
                            c2 = yU;
                        }
                        if (RandomGenerator.nextDouble() <= 0.5) {
                            offSpring[0].getVariable(i).setValue(c2);
                            offSpring[1].getVariable(i).setValue(c1);
                            continue;
                        }
                        offSpring[0].getVariable(i).setValue(c1);
                        offSpring[1].getVariable(i).setValue(c2);
                        continue;
                    }
                    offSpring[0].getVariable(i).setValue(valueX1);
                    offSpring[1].getVariable(i).setValue(valueX2);
                    continue;
                }
                offSpring[0].getVariable(i).setValue(valueX2);
                offSpring[1].getVariable(i).setValue(valueX1);
            }
        }
        return offSpring;
    }

    public Solution[] execute(Solution parent1, Solution parent2) {
        return this.doCrossover(this.probability, parent1, parent2);
    }
}

