/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.crossover;

import jeco.kernel.operator.crossover.CrossoverOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Variable;
import jeco.kernel.util.RandomGenerator;

public class SinglePointCrossover
extends CrossoverOperator {
    public static final double DEFAULT_PROBABILITY = 0.9;
    public static final boolean DEFAULT_FIXED_CROSSOVER_POINT = true;
    protected double probability;
    protected boolean fixedCrossoverPoint;

    public SinglePointCrossover() {
        this.probability = 0.9;
        this.fixedCrossoverPoint = true;
    }

    public SinglePointCrossover(boolean fixedCrossoverPoint, double probability) {
        this.probability = probability;
        this.fixedCrossoverPoint = fixedCrossoverPoint;
    }

    private int computeCrossoverPoint(int sol1Length, int sol2Length) {
        int point = 0;
        point = sol1Length < sol2Length ? RandomGenerator.nextInt(0, sol1Length) : RandomGenerator.nextInt(0, sol1Length);
        return point;
    }

    private void makeNewSolution(Solution sol1, Solution sol2) {
        int sol1Length = sol1.getVariables().length;
        int sol2Length = sol2.getVariables().length;
        if (this.fixedCrossoverPoint) {
            int point1 = this.computeCrossoverPoint(sol1Length, sol2Length);
            for (int i = 0; i < point1; ++i) {
                Variable tmp1 = sol1.getVariable(i);
                Variable tmp2 = sol2.getVariable(i);
                sol1.setVariable(i, tmp2);
                sol2.setVariable(i, tmp1);
            }
        } else {
            int i;
            int point1 = RandomGenerator.nextInt(sol1Length);
            int point2 = RandomGenerator.nextInt(sol2Length);
            Solution tmp1 = sol1.clone();
            Solution tmp2 = sol2.clone();
            int index = 0;
            for (i = 0; i < point1; ++i) {
                sol1.setVariable(index++, tmp1.getVariable(i));
            }
            for (i = point2; i < sol2Length; ++i) {
                sol1.setVariable(index++, tmp2.getVariable(i));
            }
            for (i = 0; i < point2; ++i) {
                sol2.setVariable(index++, tmp2.getVariable(i));
            }
            for (i = point1; i < sol1Length; ++i) {
                sol2.setVariable(index++, tmp1.getVariable(i));
            }
        }
    }

    public Solution[] doCrossover(double probability, Solution parent1, Solution parent2) {
        Solution[] offSpring = new Solution[2];
        Solution offSpring0 = parent1.clone();
        Solution offSpring1 = parent2.clone();
        if (RandomGenerator.nextDouble() <= probability) {
            if (RandomGenerator.nextBoolean()) {
                this.makeNewSolution(offSpring0, offSpring1);
            } else {
                this.makeNewSolution(offSpring1, offSpring0);
            }
        }
        offSpring[0] = offSpring0;
        offSpring[1] = offSpring1;
        return offSpring;
    }

    public Solution[] execute(Solution parent1, Solution parent2) {
        return this.doCrossover(this.probability, parent1, parent2);
    }
}

