/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.operator.selector;

import java.util.Comparator;
import java.util.logging.Logger;
import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.operator.selector.SelectionOperator;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.RandomGenerator;

public class BinaryTournamentNSGAII
extends SelectionOperator {
    private static Logger logger = Logger.getLogger(BinaryTournamentNSGAII.class.getName());
    protected Comparator<Solution> comparator = new SolutionDominance();

    public Solution execute(Solutions population) {
        Solution solution2;
        int index1;
        int popSize = population.size();
        if (popSize < 2) {
            logger.severe("Population size must be greater or equal than 2.");
            return null;
        }
        int index2 = index1 = RandomGenerator.nextInt(popSize);
        while (index2 == index1) {
            index2 = RandomGenerator.nextInt(popSize);
        }
        Solution solution1 = (Solution)population.get(index1);
        int flag = this.comparator.compare(solution1, solution2 = (Solution)population.get(index2));
        if (flag < 0) {
            return solution1;
        }
        if (flag > 0) {
            return solution2;
        }
        if (solution1.getProperty("crowdingDistance").doubleValue() > solution2.getProperty("crowdingDistance").doubleValue()) {
            return solution1;
        }
        if (solution2.getProperty("crowdingDistance").doubleValue() > solution1.getProperty("crowdingDistance").doubleValue()) {
            return solution2;
        }
        if (RandomGenerator.nextDouble() < 0.5) {
            return solution1;
        }
        return solution2;
    }
}

