/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.problem;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solution {
    protected Variable[] variables;
    protected double[] objectives;
    protected Map<String, Number> properties;

    public Variable getVariable(int index) {
        return this.variables[index];
    }

    public Variable[] getVariables() {
        return this.variables;
    }

    public void setVariable(int index, Variable variable) {
        this.variables[index] = variable;
    }

    public double getObjective(int index) {
        return this.objectives[index];
    }

    public double[] getObjectives() {
        return this.objectives;
    }

    public void setObjective(int i, double value) {
        this.objectives[i] = value;
    }

    public Number getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Number value) {
        this.properties.put(name, value);
    }

    public Solution(Problem problem) {
        this.variables = new Variable[problem.getNumberOfVariables()];
        this.objectives = new double[problem.getNumberOfObjectives()];
        this.properties = new HashMap<String, Number>();
    }

    public Solution(int dimension) {
        this.variables = null;
        this.objectives = new double[dimension];
        this.properties = new HashMap<String, Number>();
    }

    public Solution clone() {
        int i;
        Solution clone = new Solution(this.objectives.length);
        clone.variables = new Variable[this.variables.length];
        for (i = 0; i < this.variables.length; ++i) {
            clone.variables[i] = this.variables[i].clone();
        }
        for (i = 0; i < this.objectives.length; ++i) {
            clone.objectives[i] = this.objectives[i];
        }
        for (Map.Entry<String, Number> entry : this.properties.entrySet()) {
            clone.properties.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public int compareTo(Solution solution, Comparator<Solution> comparator) {
        return comparator.compare(this, solution);
    }

    public boolean objectivesEquals(Solution right) {
        int n = Math.min(this.objectives.length, right.objectives.length);
        double[] z1 = this.getObjectives();
        double[] z2 = right.getObjectives();
        for (int i = 0; i < n; ++i) {
            if (z1[i] == z2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < this.variables.length; ++i) {
            buffer.append(this.variables[i].toString() + " ");
        }
        for (i = 0; i < this.objectives.length; ++i) {
            buffer.append(this.objectives[i] + " ");
        }
        return buffer.toString();
    }
}

