/*
 * Decompiled with CFR 0.152.
 */
package jeco.kernel.util;

import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryNode<T> {
    protected BinaryNode<T> parent = null;
    protected T value;
    protected BinaryNode<T> left;
    protected BinaryNode<T> right;

    public BinaryNode<T> getParent() {
        return this.parent;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public BinaryNode<T> getLeft() {
        return this.left;
    }

    public void setLeft(BinaryNode<T> left) {
        if (left != null) {
            left.parent = this;
        }
        if (this.left != null) {
            this.left.parent = null;
        }
        this.left = left;
    }

    public BinaryNode<T> getRight() {
        return this.right;
    }

    public void setRight(BinaryNode<T> right) {
        if (right != null) {
            right.parent = this;
        }
        if (this.right != null) {
            this.right.parent = null;
        }
        this.right = right;
    }

    public static <T> BinaryNode<T> buildFromPolish(LinkedList<T> stackRest, Set<T> operators) {
        if (stackRest.isEmpty()) {
            return null;
        }
        T currentValue = stackRest.removeLast();
        BinaryNode<T> node = new BinaryNode<T>(currentValue);
        if (node.isOperator(operators)) {
            node.setRight(BinaryNode.buildFromPolish(stackRest, operators));
            node.setLeft(BinaryNode.buildFromPolish(stackRest, operators));
        }
        return node;
    }

    public BinaryNode(T value, BinaryNode<T> left, BinaryNode<T> right) {
        this.value = value;
        this.setLeft(left);
        this.setRight(right);
    }

    public BinaryNode(T value) {
        this(value, null, null);
    }

    public boolean isOperand(Set<T> operators) {
        return !operators.contains(this.value);
    }

    public boolean isOperator(Set<T> operators) {
        return !this.isOperand(operators);
    }

    public BinaryNode<T> commonAncestor(BinaryNode<T> node2) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.contains(node2)) {
            return this.parent;
        }
        return this.parent.commonAncestor(node2);
    }

    public boolean contains(BinaryNode<T> node) {
        if (this == node) {
            return true;
        }
        boolean containsLeft = false;
        boolean containsRight = false;
        if (this.left != null) {
            containsLeft = this.left.contains(node);
        }
        if (this.right != null) {
            containsRight = this.right.contains(node);
        }
        return containsLeft || containsRight;
    }

    public String traverseInOrder() {
        StringBuffer buffer = new StringBuffer();
        if (this.left != null) {
            buffer.append(this.left.traverseInOrder());
        }
        buffer.append(this.value.toString() + " ");
        if (this.right != null) {
            buffer.append(this.right.traverseInOrder());
        }
        return buffer.toString();
    }

    public String traversePostOrder() {
        StringBuffer buffer = new StringBuffer();
        if (this.left != null) {
            buffer.append(this.left.traversePostOrder());
        }
        if (this.right != null) {
            buffer.append(this.right.traversePostOrder());
        }
        buffer.append(this.value.toString() + " ");
        return buffer.toString();
    }

    public String toString() {
        return this.traversePostOrder();
    }
}

