/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.ddts;

import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.VariableNumeric;
import jeco.kernel.util.Xml;
import org.w3c.dom.Element;

public abstract class DynamicDataTypes
extends Problem {
    public static final int AR = 0;
    public static final int ARP = 1;
    public static final int SLL = 2;
    public static final int DLL = 3;
    public static final int SLLO = 4;
    public static final int DLLO = 5;
    public static final int SLLAR = 6;
    public static final int DLLAR = 7;
    public static final int SLLARO = 8;
    public static final int DLLARO = 9;
    public static final String[] ddts = new String[]{"AR", "AR(P)", "SLL", "DLL", "SLL(O)", "DLL(O)", "SLL(AR)", "DLL(AR)", "SLL(ARO)", "DLL(ARO)"};
    private double cacheAccessTime;
    private double dramAccessTime;
    private double cacheLineSize;
    private double dramBandwith;
    private double cpuPower;
    private double cacheAccessEnergy;
    private double dramAccessPower;
    private long[] Ne;
    private double[] NeSd;
    private double[] Nve;
    private int Na;
    private double[] Nn;
    private int[] Te;
    private int Tref;
    private long[][] readsPerDdt;
    private long[][] writesPerDdt;
    private long[] readsPlusWritesPerDdt;
    private double[][] cacheMissesL1;
    protected int[] lowerBound;
    protected int[] upperBound;

    public DynamicDataTypes(String name, String profilePath, double cacheAccessTime, double dramAccessTime, double cacheLineSize, double dramBandwith, double cpuPower, double cacheAccessEnergy, double dramAccessPower) {
        super(name, 0, 3);
        this.cacheAccessTime = cacheAccessTime;
        this.dramAccessTime = dramAccessTime;
        this.cacheLineSize = cacheLineSize;
        this.dramBandwith = dramBandwith;
        this.cpuPower = cpuPower;
        this.cacheAccessEnergy = cacheAccessEnergy;
        this.dramAccessPower = dramAccessPower;
        this.initializeProblem(profilePath);
        this.lowerBound = new int[this.numberOfVariables];
        this.upperBound = new int[this.numberOfVariables];
        for (int i = 0; i < this.numberOfVariables; ++i) {
            this.lowerBound[i] = 0;
            this.upperBound[i] = 9;
        }
    }

    public DynamicDataTypes(String name, String profilePath) {
        this(name, profilePath, 1.0E-7, 1.0E-6, 32.0, 5.0E7, 0.019, 1.0E-4, 0.001);
    }

    public void evaluate(Solution solution) {
        for (int i = 0; i < 3; ++i) {
            solution.setObjective(i, 0.0);
        }
        double performance = 0.0;
        double memory = 0.0;
        double energy = 0.0;
        double randomCount = 0.0;
        double secuentialCount = 0.0;
        double averageSize = 0.0;
        double numCreations = 0.0;
        double reads = 0.0;
        double writes = 0.0;
        double execTime = 0.0;
        for (int i = 0; i < this.numberOfVariables; ++i) {
            VariableNumeric variable = (VariableNumeric)solution.getVariable(i);
            int ddt = ((Number)variable.getValue()).intValue();
            randomCount = 0.0;
            secuentialCount = 0.0;
            averageSize = 0.0;
            numCreations = 0.0;
            reads = this.readsPerDdt[i][ddt];
            writes = this.writesPerDdt[i][ddt];
            execTime = 0.0;
            if (ddt == 0) {
                secuentialCount = 9L * this.Ne[i];
                randomCount = 2.0;
                averageSize = (long)(19 * this.Tref) + this.Ne[i] * (long)this.Te[i];
                numCreations = 1.0;
            } else if (ddt == 1) {
                secuentialCount = 10L * this.Ne[i];
                randomCount = 3.0;
                averageSize = (long)(19 * this.Tref) + this.Ne[i] * (long)(this.Tref + this.Te[i]);
                numCreations = 1.0 + this.Nve[i];
            } else if (ddt == 2) {
                secuentialCount = 7L * this.Ne[i];
                randomCount = this.Ne[i] / 2L + 1L;
                averageSize = (long)(19 * this.Tref) + this.Ne[i] * (long)(2 * this.Tref + this.Te[i]);
                numCreations = 1.0 + this.Nve[i];
            } else if (ddt == 3) {
                secuentialCount = 7L * this.Ne[i];
                randomCount = this.Ne[i] / 4L + 1L;
                averageSize = (long)(19 * this.Tref) + this.Ne[i] * (long)(3 * this.Tref + this.Te[i]);
                numCreations = 1.0 + this.Nve[i];
            } else if (ddt == 4) {
                secuentialCount = 10L * this.Ne[i];
                randomCount = this.Ne[i] / 3L + 1L;
                averageSize = (long)(20 * this.Tref) + this.Ne[i] * (long)(2 * this.Tref + this.Te[i]);
                numCreations = 1.0 + this.Nve[i];
            } else if (ddt == 5) {
                secuentialCount = 10L * this.Ne[i];
                randomCount = this.Ne[i] / 6L + 1L;
                averageSize = (long)(20 * this.Tref) + this.Ne[i] * (long)(3 * this.Tref + this.Te[i]);
                numCreations = 1.0 + this.Nve[i];
            } else if (ddt == 6) {
                secuentialCount = 18L * this.Ne[i] + (long)(8 * this.Na);
                randomCount = this.Nn[i] / 2.0 + 1.0;
                averageSize = (double)(21 * this.Tref) + this.Nn[i] * (double)((long)(21 * this.Tref) + this.Ne[i] * (long)(this.Te[i] + this.Tref));
                numCreations = (double)(2L * this.Ne[i]) + this.Nve[i];
            } else if (ddt == 7) {
                secuentialCount = 18L * this.Ne[i] + (long)(8 * this.Na);
                randomCount = this.Nn[i] / 4.0 + 1.0;
                averageSize = (double)(21 * this.Tref) + this.Nn[i] * (double)((long)(22 * this.Tref) + this.Ne[i] * (long)(this.Te[i] + this.Tref));
                numCreations = (double)(2L * this.Ne[i]) + this.Nve[i];
            } else if (ddt == 8) {
                secuentialCount = 18L * this.Ne[i] + (long)(10 * this.Na);
                randomCount = this.Nn[i] / 3.0 + 1.0;
                averageSize = (double)(22 * this.Tref) + this.Nn[i] * (double)((long)(21 * this.Tref) + this.Ne[i] * (long)(this.Te[i] + this.Tref));
                numCreations = (double)(2L * this.Ne[i]) + this.Nve[i];
            } else if (ddt == 9) {
                secuentialCount = 18L * this.Ne[i] + (long)(10 * this.Na);
                randomCount = this.Nn[i] / 6.0 + 1.0;
                averageSize = (double)(22 * this.Tref) + this.Nn[i] * (double)((long)(22 * this.Tref) + this.Ne[i] * (long)(this.Te[i] + this.Tref));
                numCreations = (double)(2L * this.Ne[i]) + this.Nve[i];
            }
            performance += 1.0E-5 * (randomCount * (3.0 * (reads + writes - 2.0) / 4.0) + secuentialCount * ((reads + writes - 2.0) / 4.0) + 2.0 * numCreations);
            memory += averageSize;
            execTime = (reads + writes) * (1.0 - this.cacheMissesL1[i][ddt]) * this.cacheAccessTime + (reads + writes) * this.cacheMissesL1[i][ddt] * this.dramAccessTime + (reads + writes) * this.cacheMissesL1[i][ddt] * this.cacheLineSize * (1.0 / this.dramBandwith);
            energy += execTime * this.cpuPower + (reads + writes) * (1.0 - this.cacheMissesL1[i][ddt]) * this.cacheAccessEnergy + (reads + writes) * this.cacheMissesL1[i][ddt] * this.cacheAccessEnergy * this.cacheLineSize + (reads + writes) * this.cacheMissesL1[i][ddt] * this.dramAccessPower * (this.dramAccessTime + this.cacheLineSize / this.dramBandwith);
        }
        solution.setObjective(0, performance);
        solution.setObjective(1, memory);
        solution.setObjective(2, energy);
    }

    private void initializeProblem(String proPath) {
        try {
            Element xmlProfileAnalyzer = Xml.getTree("ProfileAnalyzer", proPath);
            this.numberOfVariables = Xml.loadScalarAsInteger(xmlProfileAnalyzer, "VarCount");
            this.Tref = Xml.loadScalarAsInteger(xmlProfileAnalyzer, "Tref");
            this.Na = Xml.loadScalarAsInteger(xmlProfileAnalyzer, "Na");
            this.Ne = Xml.loadArrayAsLong(xmlProfileAnalyzer, "Ne");
            this.NeSd = Xml.loadArrayAsDouble(xmlProfileAnalyzer, "NeSd");
            this.Nve = Xml.loadArrayAsDouble(xmlProfileAnalyzer, "Nve");
            this.Nn = Xml.loadArrayAsDouble(xmlProfileAnalyzer, "Nn");
            this.Te = Xml.loadArrayAsInteger(xmlProfileAnalyzer, "Te");
            this.readsPerDdt = Xml.loadMatrixAsLong(xmlProfileAnalyzer, "ReadsPerDdt");
            this.writesPerDdt = Xml.loadMatrixAsLong(xmlProfileAnalyzer, "WritesPerDdt");
            this.updateCacheMisses();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void updateCacheMisses() {
        int j;
        int i;
        this.readsPlusWritesPerDdt = new long[ddts.length];
        for (i = 0; i < ddts.length; ++i) {
            this.readsPlusWritesPerDdt[i] = 0L;
        }
        for (i = 0; i < ddts.length; ++i) {
            for (j = 0; j < this.numberOfVariables; ++j) {
                int n = i;
                this.readsPlusWritesPerDdt[n] = this.readsPlusWritesPerDdt[n] + (this.readsPerDdt[j][i] + this.writesPerDdt[j][i]);
            }
        }
        this.cacheMissesL1 = new double[this.numberOfVariables][ddts.length];
        for (i = 0; i < this.numberOfVariables; ++i) {
            for (j = 0; j < ddts.length; ++j) {
                this.cacheMissesL1[i][j] = 1.0 * this.NeSd[i] * (double)this.readsPlusWritesPerDdt[j] / (double)(this.readsPlusWritesPerDdt[j] + this.readsPerDdt[i][j] + this.writesPerDdt[i][j]);
            }
        }
    }
}

