/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import java.util.ArrayList;
import jeco.lib.problems.floorplan.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coupling {
    protected Component componentFrom;
    protected Component componentTo;

    public Coupling(String validLineOfFile, ArrayList<Component> components) {
        validLineOfFile = validLineOfFile.replaceAll("\t", " ");
        validLineOfFile = validLineOfFile.replaceAll("  ", " ");
        String[] parts = validLineOfFile.split(" ");
        int idFrom = Integer.valueOf(parts[0]);
        int idTo = Integer.valueOf(parts[1]);
        this.componentFrom = this.findComponentById(idFrom, components);
        if (this.componentFrom == null) {
            throw new NullPointerException("I cannot find the block with id: " + idFrom);
        }
        this.componentTo = this.findComponentById(idTo, components);
        if (this.componentTo == null) {
            throw new NullPointerException("I cannot find the block with id: " + idTo);
        }
    }

    public Component findComponentById(int id, ArrayList<Component> components) {
        for (Component component : components) {
            if (component.id != id) continue;
            return component;
        }
        return null;
    }
}

