/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import jeco.kernel.algorithm.moga.NSGAII;
import jeco.kernel.operator.crossover.CycleCrossover;
import jeco.kernel.operator.selector.BinaryTournamentNSGAII;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.util.BinaryNode;
import jeco.kernel.util.RandomGenerator;
import jeco.lib.problems.floorplan.Board;
import jeco.lib.problems.floorplan.Component;
import jeco.lib.problems.floorplan.FloorplanConfiguration;
import jeco.lib.problems.floorplan.PostfixVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloorplanPolish
extends Problem {
    private static Logger logger = Logger.getLogger(FloorplanPolish.class.getName());
    public static final String numLayersProperty = "numLayer";
    protected Set<Component> operators = new HashSet<Component>();
    protected FloorplanConfiguration data;

    public FloorplanPolish(String name, FloorplanConfiguration data) {
        super(name, data.components.size(), 3);
        this.data = data;
        this.operators.add(new Component(-1, "H"));
        this.operators.add(new Component(-1, "V"));
        this.operators.add(new Component(-1, "Z"));
    }

    @Override
    public void evaluate(Solution solution) {
        int currentLength = 0;
        int currentWidth = 0;
        int currentHeight = 0;
        LinkedList<Component> stack = this.buildStack(solution);
        BinaryNode<Component> root = BinaryNode.buildFromPolish(stack, this.operators);
        LinkedList<BinaryNode<Component>> floorplans = this.splicer(root);
        for (BinaryNode binaryNode : floorplans) {
            this.allocate(binaryNode, currentHeight++);
            if (((Component)binaryNode.getValue()).l > currentLength) {
                currentLength = ((Component)binaryNode.getValue()).l;
            }
            if (((Component)binaryNode.getValue()).w <= currentWidth) continue;
            currentWidth = ((Component)binaryNode.getValue()).w;
        }
        double tempObj = 0.0;
        double wireObj = 0.0;
        PostfixVariable[] variables = (PostfixVariable[])solution.getVariables();
        for (int i = 0; i < variables.length; ++i) {
            Component currentBlock = variables[i].component;
            if (currentBlock.id < 0) continue;
            for (int j = 0; j < variables.length; ++j) {
                Component component = variables[j].component;
                if (component.id <= currentBlock.id) continue;
                tempObj += currentBlock.dp * component.dp / Math.sqrt(Math.pow((double)currentBlock.x + (double)currentBlock.l / 2.0 - (double)component.x - (double)component.l / 2.0, 2.0) + Math.pow((double)currentBlock.y + (double)currentBlock.w / 2.0 - (double)component.y - (double)component.w / 2.0, 2.0) + Math.pow((double)currentBlock.z + (double)currentBlock.h / 2.0 - (double)component.z - (double)component.h / 2.0, 2.0));
                HashSet<Integer> idsTo = this.data.couplings.get(currentBlock.id);
                if (idsTo == null || !idsTo.contains(component.id)) continue;
                wireObj += Math.sqrt(Math.pow((double)currentBlock.x + (double)currentBlock.l / 2.0 - (double)component.x - (double)component.l / 2.0, 2.0) + Math.pow((double)currentBlock.y + (double)currentBlock.w / 2.0 - (double)component.y - (double)component.w / 2.0, 2.0) + Math.pow((double)currentBlock.z + (double)currentBlock.h / 2.0 - (double)component.z - (double)component.h / 2.0, 2.0));
            }
        }
        solution.setProperty(numLayersProperty, currentHeight);
        double feasible = 0.0;
        if (currentLength > this.data.maxLength) {
            feasible += (double)(currentLength - this.data.maxHeight);
        }
        if (currentWidth > this.data.maxWidth) {
            feasible += (double)(currentWidth - this.data.maxWidth);
        }
        solution.setObjective(0, feasible += (double)Math.abs(currentHeight - this.data.maxHeight));
        solution.setObjective(1, tempObj);
        solution.setObjective(2, wireObj);
    }

    @Override
    public Solutions newRandomSetOfSolutions(int size) {
        Solutions solutions = new Solutions();
        Solution solution = null;
        for (int i = 0; i < size; ++i) {
            solution = new Solution(this);
            int j = 0;
            for (Component component : this.data.components.values()) {
                solution.setVariable(j, new PostfixVariable(component.clone(), j));
                ++j;
            }
            solutions.add(solution);
        }
        return solutions;
    }

    private LinkedList<Component> buildStack(Solution solution) {
        LinkedList<Component> stack = new LinkedList<Component>();
        PostfixVariable var = null;
        int currentLength = 0;
        int currentMaxLength = 0;
        String chain = null;
        for (int j = 0; j < this.numberOfVariables; ++j) {
            int k;
            currentMaxLength = j;
            var = (PostfixVariable)solution.getVariable(j);
            stack.add(var.component);
            if (currentLength >= currentMaxLength) continue;
            if ((currentLength += var.chainLength) <= currentMaxLength) {
                chain = PostfixVariable.chains[var.chainType].substring(0, var.chainLength);
                for (k = 0; k < chain.length(); ++k) {
                    stack.add(new Component(-1, chain.substring(k, k + 1)));
                }
                continue;
            }
            chain = PostfixVariable.chains[var.chainType].substring(0, currentMaxLength - (currentLength -= var.chainLength));
            for (k = 0; k < chain.length(); ++k) {
                stack.add(new Component(-1, chain.substring(k, k + 1)));
            }
            currentLength = currentMaxLength;
        }
        if (currentLength < currentMaxLength) {
            var = (PostfixVariable)solution.getVariable(this.numberOfVariables - 1);
            chain = PostfixVariable.chains[var.chainType].substring(var.chainLength, var.chainLength + currentMaxLength - currentLength);
            for (int k = 0; k < chain.length(); ++k) {
                stack.add(new Component(-1, chain.substring(k, k + 1)));
            }
        }
        return stack;
    }

    public LinkedList<BinaryNode<Component>> splicer(BinaryNode<Component> root) {
        LinkedList<BinaryNode<Component>> trees = new LinkedList<BinaryNode<Component>>();
        int layerNumber = 0;
        BinaryNode<Component> currentLayer = root;
        do {
            BinaryNode<Component> nextLayer = null;
            LinkedList<BinaryNode<Component>> linkedList = this.findZNodes(currentLayer);
            while (!linkedList.isEmpty()) {
                BinaryNode<Component> zNode = linkedList.remove();
                linkedList.addAll(this.findZNodes(zNode.getLeft()));
                if (nextLayer == null) {
                    nextLayer = zNode;
                    nextLayer.getValue().name = "L" + (layerNumber + 1);
                    continue;
                }
                BinaryNode<Component> node = zNode.commonAncestor(nextLayer.getParent());
                if (node == null) {
                    node = RandomGenerator.nextDouble() < 0.5 ? new BinaryNode<Component>(new Component(-1, "V")) : new BinaryNode<Component>(new Component(-1, "H"));
                }
                while (node.getValue().toString().equals("Z")) {
                    node = node.getParent();
                }
                BinaryNode<Component> left = nextLayer.getRight();
                BinaryNode<Component> right = zNode.getRight();
                BinaryNode<Component> nextRight = new BinaryNode<Component>(node.getValue().clone(), left, right);
                nextLayer.setRight(nextRight);
                zNode.setRight(null);
                if (zNode == zNode.getParent().getLeft()) {
                    zNode.getParent().setLeft(zNode.getLeft());
                    continue;
                }
                if (zNode != zNode.getParent().getRight()) continue;
                zNode.getParent().setRight(zNode.getLeft());
            }
            if (layerNumber == 0) {
                trees.add(currentLayer);
            } else {
                trees.add(currentLayer.getRight());
            }
            currentLayer = nextLayer;
            ++layerNumber;
        } while (currentLayer != null);
        for (BinaryNode binaryNode : trees) {
            this.removeLNodes(binaryNode);
        }
        return trees;
    }

    public LinkedList<BinaryNode<Component>> findZNodes(BinaryNode<Component> node) {
        LinkedList<BinaryNode<Component>> trees = new LinkedList<BinaryNode<Component>>();
        if (node.getValue().toString().equals("Z")) {
            trees.add(node);
        } else {
            if (node.getLeft() != null) {
                trees.addAll(this.findZNodes(node.getLeft()));
            }
            if (node.getRight() != null) {
                trees.addAll(this.findZNodes(node.getRight()));
            }
        }
        return trees;
    }

    public void removeLNodes(BinaryNode<Component> node) {
        if (node == null) {
            return;
        }
        if (node.getValue().toString().startsWith("L")) {
            node.setRight(null);
            BinaryNode<Component> parent = node.getParent();
            if (parent != null) {
                if (parent.getLeft() == node) {
                    parent.setLeft(node.getLeft());
                } else if (parent.getRight() == node) {
                    parent.setRight(node.getLeft());
                }
            } else {
                BinaryNode<Component> nodeLeft = node.getLeft();
                node.setValue(nodeLeft.getValue());
                node.setLeft(nodeLeft.getLeft());
                node.setRight(nodeLeft.getRight());
                this.removeLNodes(node);
                return;
            }
        }
        this.removeLNodes(node.getLeft());
        this.removeLNodes(node.getRight());
    }

    private void allocateFirstStep(BinaryNode<Component> root, Integer layer) {
        Component rootAsBlock = root.getValue();
        rootAsBlock.z = layer;
        if (root.isOperand(this.operators)) {
            return;
        }
        BinaryNode<Component> fLeft = root.getLeft();
        BinaryNode<Component> fRight = root.getRight();
        this.allocateFirstStep(fLeft, layer);
        this.allocateFirstStep(fRight, layer);
        Component leftAsBlock = fLeft.getValue();
        Component rightAsBlock = fRight.getValue();
        if (rootAsBlock.toString().equals("H")) {
            rootAsBlock.l = Math.max(leftAsBlock.l, rightAsBlock.l);
            rootAsBlock.w = leftAsBlock.w + rightAsBlock.w;
        }
        if (rootAsBlock.toString().equals("V")) {
            rootAsBlock.l = leftAsBlock.l + rightAsBlock.l;
            rootAsBlock.w = Math.max(leftAsBlock.w, rightAsBlock.w);
        }
    }

    private void allocateSecondStep(BinaryNode<Component> root, Integer x, Integer y) {
        Component rootAsBlock = root.getValue();
        rootAsBlock.x = x;
        rootAsBlock.y = y;
        if (root.isOperand(this.operators)) {
            return;
        }
        BinaryNode<Component> fLeft = root.getLeft();
        BinaryNode<Component> fRight = root.getRight();
        this.allocateSecondStep(fLeft, x, y);
        Component leftAsBlock = fLeft.getValue();
        Integer rightX = null;
        Integer rightY = null;
        if (rootAsBlock.toString().equals("H")) {
            rightX = leftAsBlock.x;
            rightY = leftAsBlock.y + leftAsBlock.w;
        }
        if (rootAsBlock.toString().equals("V")) {
            rightX = leftAsBlock.x + leftAsBlock.l;
            rightY = leftAsBlock.y;
        }
        this.allocateSecondStep(fRight, rightX, rightY);
    }

    public void allocate(BinaryNode<Component> floorplan, Integer layer) {
        this.allocateFirstStep(floorplan, layer);
        this.allocateSecondStep(floorplan, 0, 0);
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Parameters: filePath NumInd NumGen");
        }
        String filePath = args[0];
        Integer numIndi = Integer.valueOf(args[1]);
        Integer numGene = Integer.valueOf(args[2]);
        FloorplanConfiguration data = new FloorplanConfiguration(filePath);
        FloorplanPolish problem = new FloorplanPolish("TempAware", data);
        FloorplanPolish.optimize(problem, numIndi, numGene);
    }

    public static void optimize(FloorplanPolish problem, Integer numIndi, Integer numGene) {
        NSGAII moga = new NSGAII(problem, numIndi, numGene, new PostfixVariable.PostfixMutation(), new CycleCrossover(), new BinaryTournamentNSGAII());
        try {
            int bestIndex = -1;
            double bestObjective = Double.MAX_VALUE;
            moga.initialize();
            Solutions solutions = moga.execute();
            for (int i = 0; i < solutions.size(); ++i) {
                Solution solution = (Solution)solutions.get(i);
                if (!(solution.getObjective(0) < bestObjective)) continue;
                bestObjective = solution.getObjective(0);
                bestIndex = i;
            }
            logger.info(((Solution)solutions.get(bestIndex)).toString());
            Solution solution = (Solution)solutions.get(bestIndex);
            LinkedList<Component> list = problem.buildStack(solution);
            System.out.println(list.toString());
            Board board = new Board(10);
            board.buildBoard(solution);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static LinkedList<BinaryNode<Component>> benchmark(FloorplanPolish problem, int num) {
        String[] benchmarks = new String[]{"4 2 7 9 Z H Z 3 8 Z V 6 5 H V", "10 1 3 6 Z H Z 9 H 7 5 V H 11 V 8 H 4 H 2 12 H V", "8 2 H 4 5 V H 6 Z 9 V 7 Z 11 H 10 V 3 Z 1 V 12 V", "10 3 8 H 1 V H 2 Z 5 9 7 V H 6 Z H 4 V 11 V 12 Z", "1 9 H 46 47 H V 3 Z 17 V 14 38 4 10 44 24 V H 6 Z 7 Z 34 12 Z H Z 2 18 V 19 31 21 H V H V H 33 40 Z H Z V 15 28 47 V H 27 16 Z H Z 29 V 20 22 32 H V H 23 Z 13 H 25 V 5 V 11 8 36 H 39 48 Z 42 H V 30 35 45 26 H V 37 Z H Z V Z 41 V"};
        String floorplanAsString = benchmarks[num];
        LinkedList<Component> stack = new LinkedList<Component>();
        System.out.println("Current floorplan: " + floorplanAsString);
        String[] parts = floorplanAsString.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].equals("H") || parts[i].equals("V") || parts[i].equals("Z")) {
                stack.add(new Component(-1, parts[i]));
                continue;
            }
            stack.add(problem.data.components.get(Integer.parseInt(parts[i])));
        }
        BinaryNode<Component> root = BinaryNode.buildFromPolish(stack, problem.operators);
        LinkedList<BinaryNode<Component>> floorplans = problem.splicer(root);
        for (BinaryNode binaryNode : floorplans) {
            System.out.println(binaryNode);
        }
        return floorplans;
    }

    public static void buildFloorplanFromBenchMark(FloorplanPolish problem, int num) {
        LinkedList<BinaryNode<Component>> floorplans = FloorplanPolish.benchmark(problem, num);
        Integer numLayer = 0;
        for (BinaryNode binaryNode : floorplans) {
            Integer n = numLayer;
            Integer n2 = numLayer = Integer.valueOf(numLayer + 1);
            problem.allocate(binaryNode, n);
            System.out.println(binaryNode.toString());
            System.out.println("X: " + ((Component)binaryNode.getValue()).x + ", Y: " + ((Component)binaryNode.getValue()).y + ", L: " + ((Component)binaryNode.getValue()).l + ", W: " + ((Component)binaryNode.getValue()).w);
            Board board = new Board(30);
            board.buildBoard(binaryNode);
        }
    }
}

