/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.floorplan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import jeco.kernel.algorithm.moga.NSGAII;
import jeco.kernel.operator.crossover.SinglePointCrossover;
import jeco.kernel.operator.mutator.BinaryMutation;
import jeco.kernel.operator.selector.BinaryTournamentNSGAII;
import jeco.kernel.problem.Problem;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.Variable;
import jeco.kernel.problem.VariableBinary;
import jeco.lib.problems.floorplan.FloorplanConfiguration;

public class LiquidChannels
extends Problem {
    public static final int NUM_LCS = 20;
    public static final double TEMP_LC = 20.0;
    protected FloorplanConfiguration configuration;

    public LiquidChannels(String name, FloorplanConfiguration configuration) {
        super(name, configuration.maxLength * configuration.maxHeight, 1);
        this.configuration = configuration;
    }

    public Solutions newRandomSetOfSolutions(int size) {
        ArrayList<Integer> idxs = new ArrayList<Integer>();
        for (int i = 0; i < this.numberOfVariables; ++i) {
            idxs.add(i);
        }
        Solutions solutions = new Solutions();
        for (int i = 0; i < size; ++i) {
            Solution solution = new Solution(this);
            Collections.shuffle(idxs);
            for (int j = 0; j < this.numberOfVariables; ++j) {
                int idx = (Integer)idxs.get(j);
                VariableBinary varJ = null;
                varJ = j < 20 ? new VariableBinary(true) : new VariableBinary(false);
                solution.setVariable(idx, varJ);
            }
            solutions.add(solution);
        }
        return solutions;
    }

    public void evaluate(Solution solution) {
        Variable[] variables = solution.getVariables();
        int numLCs = 0;
        for (int i = 0; i < this.numberOfVariables; ++i) {
            boolean value = (Boolean)((VariableBinary)variables[i]).getValue();
            if (!value) continue;
            ++numLCs;
        }
        if (numLCs != 20) {
            solution.setObjective(0, Double.POSITIVE_INFINITY);
            return;
        }
        double[][][] newTemp = new double[this.configuration.maxLength][this.configuration.maxWidth][this.configuration.maxHeight];
        for (int i = 0; i < this.configuration.maxLength; ++i) {
            for (int j = 0; j < this.configuration.maxWidth; ++j) {
                for (int k = 0; k < this.configuration.maxHeight; ++k) {
                    newTemp[i][j][k] = this.configuration.temperatures[i][j][k];
                }
            }
        }
        double[][] tempLC = new double[20][this.configuration.maxWidth];
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < this.configuration.maxWidth; ++j) {
                tempLC[i][j] = 20.0;
            }
        }
        int z = -1;
        int currentLC = 0;
        int x = 0;
        for (int i = 0; i < this.numberOfVariables; ++i) {
            if (i % this.configuration.maxLength == 0) {
                ++z;
                x = 0;
            } else {
                ++x;
            }
            boolean value = (Boolean)((VariableBinary)variables[i]).getValue();
            if (!value) continue;
            for (int y = 0; y < this.configuration.maxWidth; ++y) {
                double diff = newTemp[x][y][z] - tempLC[currentLC][y];
                if (!(diff > 1.0)) continue;
                double[] dArray = newTemp[x][y];
                int n = z;
                dArray[n] = dArray[n] - Math.log(diff);
                if (y + 1 >= this.configuration.maxWidth) continue;
                double[] dArray2 = tempLC[currentLC];
                int n2 = y + 1;
                dArray2[n2] = dArray2[n2] + Math.log10(diff);
            }
            ++currentLC;
        }
        double avg = 0.0;
        for (int i = 0; i < this.configuration.maxLength; ++i) {
            for (int j = 0; j < this.configuration.maxWidth; ++j) {
                for (int k = 0; k < this.configuration.maxHeight; ++k) {
                    avg += newTemp[i][j][k];
                }
            }
        }
        solution.setObjective(0, avg /= (double)(this.configuration.maxLength * this.configuration.maxWidth * this.configuration.maxHeight));
    }

    public static void main(String[] args) {
        FloorplanConfiguration configuration = new FloorplanConfiguration("D:/jlrisco/Trabajo/Investiga/Estudiantes/DavidCuesta/devel/Interfaz-JAVA/benchmarks/NiagaraC8L2_1.xml");
        LiquidChannels liquidC = new LiquidChannels("LiquidChannels", configuration);
        NSGAII nsga2 = new NSGAII(liquidC, 100, 250, new BinaryMutation(1.0 / (double)liquidC.getNumberOfVariables()), new SinglePointCrossover(), new BinaryTournamentNSGAII());
        nsga2.initialize();
        Solutions solutions = nsga2.execute();
        Logger.getLogger(LiquidChannels.class.getName()).info("solutions.size()=" + solutions.size());
        Logger.getLogger(LiquidChannels.class.getName()).info(solutions.toString());
        Solution solution = (Solution)solutions.get(0);
        Variable[] variables = solution.getVariables();
        int z = -1;
        int x = -1;
        for (int i = 0; i < variables.length; ++i) {
            if (i % configuration.maxLength == 0) {
                ++z;
                x = 0;
            } else {
                ++x;
            }
            boolean value = (Boolean)((VariableBinary)variables[i]).getValue();
            if (!value) continue;
            Logger.getLogger(LiquidChannels.class.getName()).info("Liquig channel at (x,z)=(" + x + "," + z + ")");
        }
        liquidC.printStatistics();
    }

    public void printStatistics() {
        int x;
        int z;
        double[][] avgTempByXZ = new double[this.configuration.maxLength][this.configuration.maxWidth];
        for (int x2 = 0; x2 < this.configuration.maxLength; ++x2) {
            for (int z2 = 0; z2 < this.configuration.maxHeight; ++z2) {
                avgTempByXZ[x2][z2] = 0.0;
            }
        }
        for (z = 0; z < this.configuration.maxHeight; ++z) {
            for (x = 0; x < this.configuration.maxLength; ++x) {
                for (int y = 0; y < this.configuration.maxWidth; ++y) {
                    double[] dArray = avgTempByXZ[x];
                    int n = z;
                    dArray[n] = dArray[n] + this.configuration.temperatures[x][y][z];
                }
            }
        }
        for (z = 0; z < this.configuration.maxHeight; ++z) {
            for (x = 0; x < this.configuration.maxLength; ++x) {
                double[] dArray = avgTempByXZ[x];
                int n = z;
                dArray[n] = dArray[n] / (double)this.configuration.maxWidth;
            }
        }
        for (z = 0; z < this.configuration.maxHeight; ++z) {
            for (x = 0; x < this.configuration.maxLength; ++x) {
                Logger.getLogger(LiquidChannels.class.getName()).info("(z,x,t) = (" + z + "," + x + "," + avgTempByXZ[x][z] + ")");
            }
        }
    }
}

