/*
 * Decompiled with CFR 0.152.
 */
package jeco.lib.problems.zdt;

import jeco.kernel.operator.comparator.SolutionDominance;
import jeco.kernel.problem.Solution;
import jeco.kernel.problem.Solutions;
import jeco.kernel.problem.VariableReal;
import jeco.lib.problems.zdt.ZDT;

public class ZDT4
extends ZDT {
    public ZDT4(Integer numberOfVariables) {
        super("ZDT4", numberOfVariables);
        this.lowerBound[0] = 0.0;
        this.upperBound[0] = 1.0;
        for (int i = 1; i < numberOfVariables; ++i) {
            this.lowerBound[i] = -5.0;
            this.upperBound[i] = 5.0;
        }
    }

    public ZDT4() {
        this(10);
    }

    public void evaluate(Solution solution) {
        double xJ;
        VariableReal[] variables = (VariableReal[])solution.getVariables();
        double f1 = xJ = ((Double)variables[0].getValue()).doubleValue();
        double g = 0.0;
        for (int j = 1; j < this.numberOfVariables; ++j) {
            xJ = (Double)variables[j].getValue();
            g += xJ * xJ - 10.0 * Math.cos(Math.PI * 4 * xJ);
        }
        double h = 1.0 - Math.sqrt(f1 / (g += (double)(1 + 10 * (this.numberOfVariables - 1))));
        solution.setObjective(0, f1);
        solution.setObjective(1, g * h);
    }

    public Solutions computeParetoOptimalFront(int n) {
        Solutions result = new Solutions();
        for (int i = 0; i < n; ++i) {
            Solution sol = new Solution(this);
            double temp = 0.0 + 1.0 * (double)i / (double)(n - 1);
            sol.getVariable(0).setValue(temp);
            for (int j = 1; j < this.numberOfVariables; ++j) {
                sol.getVariable(j).setValue(0.0);
            }
            this.evaluate(sol);
            result.add(sol);
        }
        result.keepParetoNonDominated(new SolutionDominance());
        return result;
    }
}

