/*
 * Decompiled with CFR 0.152.
 */
package moea.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import moea.commons.Entity;
import moea.commons.Individual;
import moea.commons.ObjectiveVector;
import moea.commons.comparator.ComparatorObjective;
import moea.commons.comparator.ComparatorPareto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Population<I extends Individual>
extends ArrayList<I> {
    private static final long serialVersionUID = -3127751095634260511L;

    public Population<I> keepNonDominated() {
        Population<I> rest = new Population<I>();
        ComparatorPareto comparator = ComparatorPareto.getInstance();
        for (int i = 0; i < this.size() - 1; ++i) {
            block5: for (int j = i + 1; j < this.size(); ++j) {
                int compare = comparator.compare((Entity)this.get(i), (Entity)this.get(j));
                switch (compare) {
                    case -1: {
                        rest.add(this.get(j));
                        this.remove(j--);
                        continue block5;
                    }
                    case 1: {
                        rest.add(this.get(i));
                        this.remove(i--);
                        j = this.size();
                    }
                }
            }
        }
        return rest;
    }

    public I getBestIndividual(Comparator<Entity> comparator) {
        int selected = 0;
        for (int i = 1; i < this.size(); ++i) {
            int compare = comparator.compare((Entity)this.get(i), (Entity)this.get(selected));
            if (compare != -1) continue;
            selected = i;
        }
        return (I)((Individual)this.get(selected));
    }

    public void add(Population<I> population) {
        for (Individual individual : population) {
            this.add(individual);
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Individual individual : this) {
            buffer.append(individual.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public double calculateSpread() {
        double res = 0.0;
        double max = 0.0;
        double min = 0.0;
        Population<I> pop = new Population<I>();
        pop.add(this);
        for (int i = 0; i < Entity.N; ++i) {
            ComparatorObjective comp = ComparatorObjective.getInstance(i);
            Collections.sort(pop, comp);
            max = (Double)((Individual)pop.get(pop.size() - 1)).getObjectiveVector().get(i);
            min = (Double)((Individual)pop.get(0)).getObjectiveVector().get(i);
            res += Math.pow(1.0 - min / max, 2.0);
        }
        res = Math.sqrt(res);
        return res;
    }

    public double calculateSpacing() {
        Population<I> pop = new Population<I>();
        pop.add(this);
        double[] maxs = new double[Entity.N];
        for (int i = 0; i < Entity.N; ++i) {
            ComparatorObjective comp = ComparatorObjective.getInstance(i);
            Collections.sort(pop, comp);
            maxs[i] = (Double)((Individual)pop.get(pop.size() - 1)).getObjectiveVector().get(i);
        }
        ArrayList<Double> ds = new ArrayList<Double>();
        for (int i = 0; i < pop.size(); ++i) {
            ds.add(this.calculateMinDistance(i, pop, maxs));
        }
        double dsMean = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            dsMean += ((Double)ds.get(i)).doubleValue();
        }
        dsMean /= (double)pop.size();
        double res = 0.0;
        for (int i = 0; i < pop.size(); ++i) {
            res += Math.pow((Double)ds.get(i) - dsMean, 2.0);
        }
        res = Math.sqrt(res / (double)pop.size());
        return res;
    }

    private double calculateMinDistance(int i, Population<I> pop, double[] maxs) {
        double temp = 0.0;
        ArrayList<Double> di = new ArrayList<Double>();
        ObjectiveVector objI = ((Individual)pop.get(i)).getObjectiveVector();
        for (int j = 0; j < pop.size(); ++j) {
            if (i == j) continue;
            ObjectiveVector objJ = ((Individual)pop.get(j)).getObjectiveVector();
            temp = 0.0;
            for (int k = 0; k < Entity.N; ++k) {
                temp += Math.abs((Double)objI.get(k) / maxs[k] - (Double)objJ.get(k) / maxs[k]);
            }
            di.add(temp);
        }
        Collections.sort(di);
        return (Double)di.get(0);
    }
}

