/*
 * Decompiled with CFR 0.152.
 */
package moea.commons.assigner;

import ext.number.ValReal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import moea.commons.Entity;
import moea.commons.Individual;
import moea.commons.Population;
import moea.commons.comparator.ComparatorFitness;
import moea.commons.comparator.ComparatorPareto;
import moea.commons.comparator.ComparatorSigmas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignerSpea2<I extends Individual> {
    protected int K;

    public AssignerSpea2(int K) {
        this.K = K;
    }

    public void assignFitness(Population<I> pop) {
        int compare;
        int j;
        Individual indI;
        int i;
        int popSize = pop.size();
        int[] strength = new int[popSize];
        int[] raw = new int[popSize];
        double[] density = new double[popSize];
        ComparatorPareto comparator = ComparatorPareto.getInstance();
        for (i = 0; i < popSize; ++i) {
            strength[i] = 0;
            raw[i] = 0;
            density[i] = 0.0;
        }
        for (i = 0; i < popSize; ++i) {
            indI = (Individual)pop.get(i);
            for (j = 0; j < popSize; ++j) {
                if (i == j || (compare = comparator.compare(indI, (Entity)pop.get(j))) != -1) continue;
                int n = i;
                strength[n] = strength[n] + 1;
            }
        }
        for (i = 0; i < popSize; ++i) {
            indI = (Individual)pop.get(i);
            for (j = 0; j < popSize; ++j) {
                if (i == j || (compare = comparator.compare(indI, (Entity)pop.get(j))) != 1) continue;
                int n = i;
                raw[n] = raw[n] + strength[j];
            }
        }
        for (i = 0; i < popSize; ++i) {
            double sigma = this.calculateSigma(i, pop);
            density[i] = 1.0 / (sigma + 2.0);
            double fitness = (double)raw[i] + density[i];
            ((Individual)pop.get(i)).setProperty("fitness", new ValReal(fitness));
        }
    }

    public Population<I> reduceByFitness(Population<I> pop) {
        Population result = new Population();
        for (int i = 0; i < pop.size(); ++i) {
            Individual indI = (Individual)pop.get(i);
            if (!(indI.getProperty("fitness").getValue().doubleValue() < 1.0)) continue;
            result.add(indI);
        }
        return result;
    }

    public void expand(Population<I> pop, Population<I> all, int nElems) {
        int i = 0;
        int count = 0;
        int allSize = all.size();
        Collections.sort(all, ComparatorFitness.getInstance());
        for (i = 0; i < allSize; ++i) {
            Individual indI = (Individual)all.get(i);
            if (!(indI.getProperty("fitness").getValue().doubleValue() >= 1.0)) continue;
            pop.add(indI);
            if (++count == nElems) break;
        }
    }

    public Population<I> reduce(Population<I> pop, int maxSize) {
        int i;
        ArrayList<ArrayList<Double>> allSigmas = new ArrayList<ArrayList<Double>>();
        ComparatorSigmas comparator = ComparatorSigmas.getInstance();
        HashSet<Integer> erased = new HashSet<Integer>();
        int toErase = pop.size() - maxSize;
        for (i = 0; i < pop.size(); ++i) {
            allSigmas.add(this.calculateSigmas(i, pop));
        }
        while (erased.size() < toErase) {
            int min = 0;
            while (erased.contains(min)) {
                ++min;
            }
            for (i = 0; i < pop.size(); ++i) {
                if (i == min || erased.contains(i) || comparator.compare((ArrayList)allSigmas.get(i), (ArrayList)allSigmas.get(min)) != -1) continue;
                min = i;
            }
            erased.add(min);
        }
        Population result = new Population();
        for (i = 0; i < pop.size(); ++i) {
            if (erased.contains(i)) continue;
            result.add(pop.get(i));
        }
        return result;
    }

    private double calculateSigma(int i, Population<I> pop) {
        return this.calculateSigmas(i, pop).get(this.K);
    }

    private ArrayList<Double> calculateSigmas(int i, Population<I> pop) {
        int popSize = pop.size();
        ArrayList<Double> distancesToI = new ArrayList<Double>();
        Individual indI = (Individual)pop.get(i);
        for (int j = 0; j < popSize; ++j) {
            double distance = indI.getObjectiveVector().euclideanDistance(((Individual)pop.get(j)).getObjectiveVector());
            distancesToI.add(distance);
        }
        Collections.sort(distancesToI);
        return distancesToI;
    }
}

