/*
 * Decompiled with CFR 0.152.
 */
package moea.moga.selector;

import java.util.Comparator;
import moea.commons.Entity;
import moea.commons.Population;
import moea.moga.genome.Chromosome;
import moea.moga.selector.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TournamentSelector
extends Selector {
    protected int[] tournament;
    protected int tournamentSize;

    public TournamentSelector(Comparator<Entity> comparator, int tournamentSize) {
        super(comparator);
        this.tournamentSize = tournamentSize;
        this.tournament = new int[tournamentSize];
    }

    @Override
    public void update(Population<Chromosome> pop) {
        super.initialize(pop);
        for (int i = 0; i < this.poolSize; ++i) {
            this.generateTournament(pop, this.tournamentSize);
            Chromosome winner = (Chromosome)pop.get(this.tournament[0]);
            for (int j = 1; j < this.tournamentSize; ++j) {
                Chromosome currentIndividual = (Chromosome)pop.get(this.tournament[j]);
                if (this.comparator.compare(currentIndividual, winner) != -1) continue;
                winner = currentIndividual;
            }
            this.pool[i] = winner;
        }
        this.currentIndex = 0;
    }

    protected void generateTournament(Population<Chromosome> pop, int size) {
        int maxIndex = pop.size() - 1;
        int j = 0;
        while (j < size) {
            int currentRandomIndex = (int)((double)(maxIndex + 1) * Math.random());
            boolean isNewIndex = true;
            if (j <= maxIndex) {
                for (int i = 0; isNewIndex && i < j; ++i) {
                    isNewIndex = currentRandomIndex != this.tournament[i];
                }
            }
            if (!isNewIndex) continue;
            this.tournament[j++] = currentRandomIndex;
        }
    }
}

