/*
 * Decompiled with CFR 0.152.
 */
package moea.mopso.examples;

import ext.number.ValModPosInt;
import ext.number.Value;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import moea.commons.ObjectiveVector;
import moea.commons.Population;
import moea.moga.examples.Profile;
import moea.mopso.algorithms.HNSPSO;
import moea.mopso.algorithms.MOPSO;
import moea.mopso.society.Particle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileMopso
extends Particle {
    public static void initializeProblem(String proPath) {
        try {
            ValModPosInt.setModulus(10);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        Profile.initializeProblem(proPath);
        Value[] xLTemp = new Value[M];
        Value[] xUTemp = new Value[M];
        for (int i = 0; i < M; ++i) {
            xLTemp[i] = new ValModPosInt(0);
            xUTemp[i] = new ValModPosInt(9);
        }
        xL = xLTemp;
        xU = xUTemp;
    }

    public ProfileMopso() {
        super(0.4, 1.0, 1.0);
    }

    public ProfileMopso(ProfileMopso src) {
        super(src);
    }

    @Override
    public ProfileMopso clone() {
        ProfileMopso clone = new ProfileMopso(this);
        return clone;
    }

    @Override
    public void evaluate() {
        for (int i = 0; i < this.objectiveVector.size(); ++i) {
            this.objectiveVector.set(i, 0.0);
        }
        double performance = 0.0;
        double memory = 0.0;
        double energy = 0.0;
        double randomCount = 0.0;
        double secuentialCount = 0.0;
        double averageSize = 0.0;
        double numCreations = 0.0;
        double reads = 0.0;
        double writes = 0.0;
        double execTime = 0.0;
        for (int i = 0; i < M; ++i) {
            int ddt = this.x[i].intValue();
            randomCount = 0.0;
            secuentialCount = 0.0;
            averageSize = 0.0;
            numCreations = 0.0;
            reads = Profile.readsPerDdt[i][ddt];
            writes = Profile.writesPerDdt[i][ddt];
            execTime = 0.0;
            if (ddt == 0) {
                secuentialCount = 9L * Profile.Ne[i];
                randomCount = 2.0;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i] * (long)Profile.Te[i];
                numCreations = 1.0;
            } else if (ddt == 1) {
                secuentialCount = 10L * Profile.Ne[i];
                randomCount = 3.0;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i] * (long)(Profile.Tref + Profile.Te[i]);
                numCreations = 1.0 + Profile.Nve[i];
            } else if (ddt == 2) {
                secuentialCount = 7L * Profile.Ne[i];
                randomCount = Profile.Ne[i] / 2L + 1L;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i] * (long)(2 * Profile.Tref + Profile.Te[i]);
                numCreations = 1.0 + Profile.Nve[i];
            } else if (ddt == 3) {
                secuentialCount = 7L * Profile.Ne[i];
                randomCount = Profile.Ne[i] / 4L + 1L;
                averageSize = (long)(19 * Profile.Tref) + Profile.Ne[i] * (long)(3 * Profile.Tref + Profile.Te[i]);
                numCreations = 1.0 + Profile.Nve[i];
            } else if (ddt == 4) {
                secuentialCount = 10L * Profile.Ne[i];
                randomCount = Profile.Ne[i] / 3L + 1L;
                averageSize = (long)(20 * Profile.Tref) + Profile.Ne[i] * (long)(2 * Profile.Tref + Profile.Te[i]);
                numCreations = 1.0 + Profile.Nve[i];
            } else if (ddt == 5) {
                secuentialCount = 10L * Profile.Ne[i];
                randomCount = Profile.Ne[i] / 6L + 1L;
                averageSize = (long)(20 * Profile.Tref) + Profile.Ne[i] * (long)(3 * Profile.Tref + Profile.Te[i]);
                numCreations = 1.0 + Profile.Nve[i];
            } else if (ddt == 6) {
                secuentialCount = 18L * Profile.Ne[i] + (long)(8 * Profile.Na);
                randomCount = Profile.Nn[i] / 2.0 + 1.0;
                averageSize = (double)(21 * Profile.Tref) + Profile.Nn[i] * (double)((long)(21 * Profile.Tref) + Profile.Ne[i] * (long)(Profile.Te[i] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i]) + Profile.Nve[i];
            } else if (ddt == 7) {
                secuentialCount = 18L * Profile.Ne[i] + (long)(8 * Profile.Na);
                randomCount = Profile.Nn[i] / 4.0 + 1.0;
                averageSize = (double)(21 * Profile.Tref) + Profile.Nn[i] * (double)((long)(22 * Profile.Tref) + Profile.Ne[i] * (long)(Profile.Te[i] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i]) + Profile.Nve[i];
            } else if (ddt == 8) {
                secuentialCount = 18L * Profile.Ne[i] + (long)(10 * Profile.Na);
                randomCount = Profile.Nn[i] / 3.0 + 1.0;
                averageSize = (double)(22 * Profile.Tref) + Profile.Nn[i] * (double)((long)(21 * Profile.Tref) + Profile.Ne[i] * (long)(Profile.Te[i] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i]) + Profile.Nve[i];
            } else if (ddt == 9) {
                secuentialCount = 18L * Profile.Ne[i] + (long)(10 * Profile.Na);
                randomCount = Profile.Nn[i] / 6.0 + 1.0;
                averageSize = (double)(22 * Profile.Tref) + Profile.Nn[i] * (double)((long)(22 * Profile.Tref) + Profile.Ne[i] * (long)(Profile.Te[i] + Profile.Tref));
                numCreations = (double)(2L * Profile.Ne[i]) + Profile.Nve[i];
            }
            performance += 1.0E-5 * (randomCount * (3.0 * (reads + writes - 2.0) / 4.0) + secuentialCount * ((reads + writes - 2.0) / 4.0) + 2.0 * numCreations);
            memory += averageSize;
            execTime = (reads + writes) * (1.0 - Profile.cacheMissesL1[i][ddt]) * Profile.cacheAccessTime + (reads + writes) * Profile.cacheMissesL1[i][ddt] * Profile.dramAccessTime + (reads + writes) * Profile.cacheMissesL1[i][ddt] * Profile.cacheLineSize * (1.0 / Profile.dramBandwith);
            energy += execTime * Profile.cpuPower + (reads + writes) * (1.0 - Profile.cacheMissesL1[i][ddt]) * Profile.cacheAccessEnergy + (reads + writes) * Profile.cacheMissesL1[i][ddt] * Profile.cacheAccessEnergy * Profile.cacheLineSize + (reads + writes) * Profile.cacheMissesL1[i][ddt] * Profile.dramAccessPower * (Profile.dramAccessTime + Profile.cacheLineSize / Profile.dramBandwith);
        }
        this.objectiveVector.set(0, performance);
        this.objectiveVector.set(1, memory);
        this.objectiveVector.set(2, energy);
    }

    public static void main(String[] args) throws Exception {
        String outDir = ".";
        if (args.length < 5) {
            System.out.println("Usage:");
            System.out.println("java -jar Profile.jar <XML-PROFILE> <HNSPSO> <NumTrials:1..Inf> <NumOfIndividuals:1..Inf> <MaxGenerations:1..Inf> <UniformAnalysis:true|false>");
            args = new String[]{"Physics.pro", "HNSPSO", "10", "200", "4000"};
            outDir = "D:/jlrisco/Trabajo/MisPapers/IEEE T EVOLUT COMPUT/2007/Results";
            return;
        }
        String proPath = outDir + File.separator + args[0];
        String algorithmName = args[1];
        Integer numberOfTrials = Integer.valueOf(args[2]);
        Integer numberOfIndividuals = Integer.valueOf(args[3]);
        Integer maxGenerations = Integer.valueOf(args[4]);
        ProfileMopso.initializeProblem(proPath);
        MOPSO algorithm = null;
        for (int i = 0; i < numberOfTrials; ++i) {
            BufferedWriter loggerPop = new BufferedWriter(new FileWriter(new File(proPath + "." + algorithmName + "." + i)));
            System.out.println("Iteration number: " + i);
            Population<Particle> popIni = new Population<Particle>();
            for (int k = 0; k < numberOfIndividuals; ++k) {
                ProfileMopso particle = new ProfileMopso();
                popIni.add(particle);
            }
            if (algorithmName.equals("HNSPSO")) {
                algorithm = new HNSPSO("Mopso", popIni, maxGenerations);
            }
            double start = System.currentTimeMillis();
            while (!algorithm.done()) {
                if (algorithm.getT() % 100 == 0) {
                    System.out.println("Current generation: " + algorithm.getT());
                }
                algorithm.step();
            }
            double end = System.currentTimeMillis();
            System.out.println("Time: " + (end - start) / 1000.0);
            System.out.println("done.");
            loggerPop.write(ProfileMopso.ParetoFrontToString(algorithm.getPopulation()));
            loggerPop.flush();
            loggerPop.close();
        }
    }

    public static String ParetoFrontToString(Population<Particle> pop) {
        StringBuffer buffer = new StringBuffer();
        Population<Particle> popTemp = new Population<Particle>();
        popTemp.add(pop);
        popTemp.keepNonDominated();
        for (Particle chrom : popTemp) {
            ObjectiveVector objs = chrom.getObjectiveVector();
            for (int i = 0; i < N; ++i) {
                buffer.append(objs.get(i) + "\t");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

