/*
 * Decompiled with CFR 0.152.
 */
package FitnessEvaluation.LSystem;

import FitnessEvaluation.FitnessFunction;
import Fractal.LSystem2FDBoxCounting;
import Individuals.Individual;
import java.util.Properties;

public class LSystemDimension
implements FitnessFunction {
    private double targetFractalDim;
    private int boxCountDivision;

    public void getFitness(Individual i) {
        String grammar = i.getPhenotype().getString().substring(6);
        String depth = i.getPhenotype().getString().substring(0, 1);
        String angle = i.getPhenotype().getString().substring(1, 6);
        double fractalDim = new LSystem2FDBoxCounting(null, grammar, Integer.parseInt(depth), Float.parseFloat(angle), this.boxCountDivision).calcFractalDimension();
        i.getFitness().setDouble(Math.abs(this.targetFractalDim - fractalDim));
    }

    public boolean canCache() {
        return true;
    }

    public void setProperties(Properties p) {
        try {
            this.targetFractalDim = Double.parseDouble(p.getProperty("targetFractalDimension", "1.666"));
            System.out.format("%s=%.3f%n", "targetFractalDimension", this.targetFractalDim);
        }
        catch (NumberFormatException e) {
            this.targetFractalDim = 1.666;
            System.out.format("%s [%s] using default: %.3f%n", "targetFractalDimension", e, this.targetFractalDim);
        }
        try {
            this.boxCountDivision = Integer.parseInt(p.getProperty("boxCountDivision", "512"));
            System.out.format("%s=%d%n", "boxCountDivision", this.boxCountDivision);
        }
        catch (NumberFormatException e) {
            this.boxCountDivision = 512;
            System.out.format("%s [%s] using default: %d%n", "boxCountDivision", e, this.boxCountDivision);
        }
    }
}

