/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

import Fractal.LSystem2State;
import Fractal.LSystem2StateTrace;
import Fractal.LSystem2StateTraceEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;

public class LSystem2 {
    private String macro;
    private float angle;

    public LSystem2(String grammar, int depth, float angle) {
        this(null, grammar, depth, angle);
    }

    public LSystem2(String axiom, String grammar, int depth, float angle) {
        this.angle = (float)((double)angle * Math.PI / 180.0);
        this.compile(axiom == null ? null : axiom.replaceAll("\\s", ""), grammar.replaceAll("\\s", ""), depth);
    }

    private void compile(String axiom, String grammar, int depth) {
        String[] parts = grammar.split("=");
        if (axiom == null || axiom.length() == 0) {
            String string = axiom = parts.length > 1 ? parts[0] : "F";
            if (axiom == null || axiom.length() == 0) {
                axiom = "F";
            }
        }
        this.macro = grammar = parts.length > 1 ? parts[1] : parts[0];
        while (depth > 1) {
            this.macro = this.macro.replace("F", grammar);
            --depth;
        }
        this.macro = axiom.replace("F", this.macro);
        if (this.macro.indexOf(45) == -1 && this.macro.indexOf(43) == -1) {
            this.angle = 0.0f;
        }
    }

    void execute(LSystem2StateTrace stateTrace) {
        this.execute(null, stateTrace);
    }

    void execute(Object user, LSystem2StateTrace stateTrace) {
        StringReader instruction = new StringReader(this.macro);
        Stack<LSystem2State> stack = new Stack<LSystem2State>();
        LSystem2State state = new LSystem2State();
        try {
            int fetch;
            while ((fetch = instruction.read()) != -1) {
                switch ((char)fetch) {
                    case 'F': {
                        this.move(state, true, user, stateTrace);
                        break;
                    }
                    case 'f': {
                        this.move(state, false, user, stateTrace);
                        break;
                    }
                    case '+': {
                        state.turn(this.angle);
                        break;
                    }
                    case '-': {
                        state.turn(-this.angle);
                        break;
                    }
                    case '[': {
                        stack.push(new LSystem2State(state));
                        break;
                    }
                    case ']': {
                        if (stack.empty()) break;
                        state = (LSystem2State)stack.pop();
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public String getDerivedGrammar() {
        return this.macro;
    }

    public float getAngle() {
        return this.angle;
    }

    private void move(LSystem2State state, boolean doTrace, Object user, LSystem2StateTrace stateTrace) {
        LSystem2State trace = null;
        LSystem2StateTraceEvent event = new LSystem2StateTraceEvent();
        if (doTrace) {
            trace = new LSystem2State(state);
        }
        state.move();
        if (stateTrace != null) {
            event.state = state;
            event.trace = trace;
            event.user = user;
            stateTrace.Update(event);
        }
    }
}

