/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

import Fractal.LSystem2FDBoxCounting;
import Fractal.LSystem2Panel;
import Fractal.PSLSystem2;
import Util.FileNameExtensionFilter;
import Util.GEVAHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LSystem2Control
extends JPanel {
    private JTextField txtAxiom = new JTextField();
    private JTextField txtGrammar = new JTextField();
    private JSpinner txtDepth = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
    private JSpinner txtAngle = new JSpinner(new SpinnerNumberModel(0.0, -360.0, 360.0, 0.25));
    private JTextField txtDerived = new JTextField();
    private JTextField txtDimension = new JTextField();
    private LSystem2Panel guiLSystem;
    private JButton cmdSavePS = new JButton("Save PostScript");
    private Component cmdClose = null;

    public LSystem2Control(String grammar, int depth, float angle, Component close) {
        this("", grammar, depth, angle, close);
    }

    public LSystem2Control(String axiom, String grammar, int depth, float angle, Component close) {
        this.guiLSystem = new LSystem2Panel(axiom, grammar, depth, angle);
        this.txtAxiom.setText(axiom.replaceAll("\\s", ""));
        this.txtGrammar.setText(grammar.replaceAll("\\s", ""));
        this.txtDepth.setValue(depth);
        this.txtAngle.setValue(Float.valueOf(angle));
        this.txtDerived.setText(this.guiLSystem.getDerivedGrammar());
        this.calcFractalDimension();
        this.cmdClose = close;
        this.initialisePane();
    }

    private void initialisePane() {
        super.setLayout(new BorderLayout());
        JPanel grid = new JPanel();
        JPanel flow = new JPanel();
        grid.setLayout(new GridBagLayout());
        flow.setLayout(new FlowLayout());
        this.txtAxiom.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                LSystem2Control.this.guiLSystem.setAxiom(LSystem2Control.this.txtAxiom.getText());
                LSystem2Control.this.txtDerived.setText(LSystem2Control.this.guiLSystem.getDerivedGrammar());
                LSystem2Control.this.calcFractalDimension();
            }
        });
        this.txtGrammar.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                LSystem2Control.this.guiLSystem.setGrammar(LSystem2Control.this.txtGrammar.getText());
                LSystem2Control.this.txtDerived.setText(LSystem2Control.this.guiLSystem.getDerivedGrammar());
                LSystem2Control.this.calcFractalDimension();
            }
        });
        this.txtDepth.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LSystem2Control.this.guiLSystem.setDepth((Integer)LSystem2Control.this.txtDepth.getValue());
                LSystem2Control.this.txtDerived.setText(LSystem2Control.this.guiLSystem.getDerivedGrammar());
                LSystem2Control.this.calcFractalDimension();
            }
        });
        this.txtAngle.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LSystem2Control.this.guiLSystem.setAngle(LSystem2Control.this.getFloatValue(LSystem2Control.this.txtAngle.getValue()));
                LSystem2Control.this.txtDerived.setText(LSystem2Control.this.guiLSystem.getDerivedGrammar());
                LSystem2Control.this.calcFractalDimension();
            }
        });
        this.txtDerived.setEditable(false);
        this.txtDimension.setEditable(false);
        this.cmdSavePS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LSystem2Control.this.savePS();
            }
        });
        GEVAHelper.gridAdd(grid, new JLabel("Axiom:"), 0, 0, 0.0);
        GEVAHelper.gridAdd(grid, this.txtAxiom, 1, 0, 1.0);
        GEVAHelper.gridAdd(grid, new JLabel("Grammar:"), 0, 1, 0.0);
        GEVAHelper.gridAdd(grid, this.txtGrammar, 1, 1, 1.0);
        GEVAHelper.gridAdd(grid, new JLabel("Depth:"), 0, 2, 0.0);
        GEVAHelper.gridAdd(grid, this.txtDepth, 1, 2, 1.0);
        GEVAHelper.gridAdd(grid, new JLabel("Angle:"), 0, 3, 0.0);
        GEVAHelper.gridAdd(grid, this.txtAngle, 1, 3, 1.0);
        GEVAHelper.gridAdd(grid, new JLabel("Derived:"), 0, 4, 0.0);
        GEVAHelper.gridAdd(grid, this.txtDerived, 1, 4, 1.0);
        GEVAHelper.gridAdd(grid, new JLabel("Dimension:"), 0, 5, 0.0);
        GEVAHelper.gridAdd(grid, this.txtDimension, 1, 5, 1.0);
        flow.add(this.cmdSavePS);
        if (this.cmdClose != null) {
            flow.add(this.cmdClose);
        }
        super.add((Component)grid, "North");
        super.add((Component)this.guiLSystem, "Center");
        super.add((Component)flow, "South");
        super.setVisible(true);
    }

    private void savePS() {
        PSLSystem2 lSystem = new PSLSystem2(this.txtAxiom.getText(), this.txtGrammar.getText(), (Integer)this.txtDepth.getValue(), this.getFloatValue(this.txtAngle.getValue()));
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("PostScript", "ps");
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(null) == 0) {
            String filename = chooser.getSelectedFile().toString();
            if (!filename.toLowerCase().endsWith(".ps")) {
                filename = filename + ".ps";
            }
            lSystem.save(filename);
        }
    }

    private float getFloatValue(Object value) {
        return Float.parseFloat(String.valueOf(value));
    }

    private void calcFractalDimension() {
        this.txtDimension.setText(String.format("%.2f", new LSystem2FDBoxCounting(this.txtAxiom.getText(), this.txtGrammar.getText(), (Integer)this.txtDepth.getValue(), this.getFloatValue(this.txtAngle.getValue()), 256).calcFractalDimension()));
    }
}

