/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

import Fractal.LSystem2Renderer;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class LSystem2Panel
extends JPanel {
    private LSystem2Renderer lSystem;
    private String axiom;
    private String grammar;
    private int depth;
    private float angle;
    private int centerX = 0;
    private int centerY = 0;
    private float scale = 1.0f;

    public LSystem2Panel(String grammar, int depth, float angle) {
        this(null, grammar, depth, angle);
    }

    public LSystem2Panel(String axiom, String grammar, int depth, float angle) {
        this.axiom = axiom;
        this.grammar = grammar;
        this.depth = depth;
        this.angle = angle;
        this.createLSystem();
    }

    public void setAxiom(String axiom) {
        this.axiom = axiom;
        this.createLSystem();
        super.repaint();
    }

    public void setGrammar(String grammar) {
        this.grammar = grammar;
        this.createLSystem();
        super.repaint();
    }

    public void setDepth(int depth) {
        this.depth = depth;
        this.createLSystem();
        super.repaint();
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.createLSystem();
        super.repaint();
    }

    protected void setScale(float scale) {
        this.scale = scale;
        super.repaint();
    }

    public String getDerivedGrammar() {
        return this.lSystem.getDerivedGrammar();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int size = Math.min(this.getWidth(), this.getHeight());
        size = (int)((float)size * this.scale);
        this.centerX = (this.getWidth() - size) / 2;
        this.centerY = (this.getHeight() - size) / 2;
        this.lSystem.setDimension(size - 1, size - 1);
        this.lSystem.render(graphics);
    }

    private void createLSystem() {
        this.lSystem = new LSystem2Renderer(this.axiom, this.grammar, this.depth, this.angle){

            protected void drawLine(Object user, int x, int y, int u, int v) {
                assert (user instanceof Graphics) : user.getClass().getName();
                Graphics graphics = (Graphics)user;
                graphics.setColor(Color.green);
                graphics.drawLine(x + LSystem2Panel.this.centerX, y + LSystem2Panel.this.centerY, u + LSystem2Panel.this.centerX, v + LSystem2Panel.this.centerY);
            }
        };
    }
}

