/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

import Fractal.LSystem2;
import Fractal.LSystem2State;
import Fractal.LSystem2StateTrace;
import Fractal.LSystem2StateTraceEvent;

public abstract class LSystem2Renderer {
    private LSystem2 lSystem;
    private float width;
    private float height;

    public LSystem2Renderer(String axiom, String grammar, int depth, float angle) {
        this.lSystem = new LSystem2(axiom, grammar, depth, angle);
    }

    private void scale(LSystemScale scale) {
        this.lSystem.execute(scale, new LSystem2StateTrace(){

            public void Update(LSystem2StateTraceEvent event) {
                LSystem2State state = event.state;
                LSystemScale scale = (LSystemScale)event.user;
                if (state.getX() < scale.minX) {
                    scale.minX = state.getX();
                }
                if (state.getY() < scale.minY) {
                    scale.minY = state.getY();
                }
                if (state.getX() > scale.maxX) {
                    scale.maxX = state.getX();
                }
                if (state.getY() > scale.maxY) {
                    scale.maxY = state.getY();
                }
            }
        });
        scale.fix();
    }

    private void render(LSystemRender render) {
        this.lSystem.execute(render, new LSystem2StateTrace(){

            public void Update(LSystem2StateTraceEvent event) {
                LSystem2State state = event.state;
                LSystem2State trace = event.trace;
                LSystemRender render = (LSystemRender)event.user;
                if (trace != null) {
                    int x = render.getX(trace.getX());
                    int y = render.getY(trace.getY());
                    int u = render.getX(state.getX());
                    int v = render.getY(state.getY());
                    LSystem2Renderer.this.drawLine(render.user, x, y, u, v);
                }
            }
        });
    }

    public void setDimension(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public void render(Object user) {
        LSystemScale scale = new LSystemScale();
        LSystemRender render = new LSystemRender();
        render.user = user;
        render.scale = scale;
        render.width = this.width;
        render.height = this.height;
        this.scale(scale);
        this.render(render);
    }

    protected abstract void drawLine(Object var1, int var2, int var3, int var4, int var5);

    public String getDerivedGrammar() {
        return this.lSystem.getDerivedGrammar();
    }

    class LSystemRender {
        public Object user;
        public LSystemScale scale;
        public float width;
        public float height;

        LSystemRender() {
        }

        public int getX(float x) {
            x = (x - this.scale.minX) * this.width / (this.scale.maxX - this.scale.minX);
            return (int)x;
        }

        public int getY(float y) {
            y = (y - this.scale.minY) * this.height / (this.scale.maxY - this.scale.minY);
            return (int)y;
        }
    }

    class LSystemScale {
        public float minX = Float.MAX_VALUE;
        public float minY = Float.MAX_VALUE;
        public float maxX = Float.MIN_VALUE;
        public float maxY = Float.MIN_VALUE;

        LSystemScale() {
        }

        public void fix() {
            if (this.maxX - this.minX > this.maxY - this.minY) {
                float size = this.maxX - this.minX;
                size = (size - (this.maxY - this.minY)) / 2.0f;
                this.maxY += size;
                this.minY -= size;
            } else {
                float size = this.maxY - this.minY;
                size = (size - (this.maxX - this.minX)) / 2.0f;
                this.maxX += size;
                this.minX -= size;
            }
        }
    }
}

