/*
 * Decompiled with CFR 0.152.
 */
package Fractal;

public class LSystem2State {
    private float x;
    private float y;
    private float angle;

    public LSystem2State() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.angle = -1.5707964f;
    }

    public LSystem2State(LSystem2State state) {
        this.x = state.getX();
        this.y = state.getY();
        this.angle = state.getAngle();
    }

    void move() {
        this.x = (float)((double)this.x + Math.cos(this.angle));
        this.y = (float)((double)this.y + Math.sin(this.angle));
    }

    void turn(float distance) {
        this.angle += distance;
        if (distance > 0.0f) {
            while ((double)this.angle >= Math.PI * 2) {
                this.angle = (float)((double)this.angle - Math.PI * 2);
            }
        } else {
            while (this.angle < 0.0f) {
                this.angle = (float)((double)this.angle + Math.PI * 2);
            }
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getAngle() {
        return this.angle;
    }
}

