/*
 * Decompiled with CFR 0.152.
 */
package Main.Tutorials;

import Algorithm.MyFirstSearchEngine;
import Algorithm.SimplePipeline;
import Main.ParameterizedState;
import Mapper.GEGrammar;
import Operator.CrossoverModule;
import Operator.JoinOperator;
import Operator.MutationOperator;
import Operator.Operations.IntFlipMutation;
import Operator.Operations.ReplacementOperation;
import Operator.Operations.SelectionOperation;
import Operator.Operations.SinglePointCrossover;
import Operator.SelectionScheme;
import Util.Random.MersenneTwisterFast;

public class Tutorial5
extends ParameterizedState {
    public Tutorial5() {
        this.rng = new MersenneTwisterFast();
        this.propertiesFilePath = "../param/Parameters/Tutorials/Tutorial5.properties";
    }

    public void setup() {
    }

    public void setup(String[] args) {
        this.readProperties(args);
        GEGrammar grammar = new GEGrammar(this.properties);
        MyFirstSearchEngine alg = new MyFirstSearchEngine();
        this.initialiser = this.getInitialiser(grammar, this.rng, this.properties);
        SinglePointCrossover singlePointCrossover = new SinglePointCrossover(this.rng, this.properties);
        CrossoverModule crossoverModule = new CrossoverModule(this.rng, singlePointCrossover);
        IntFlipMutation mutation = new IntFlipMutation(this.rng, this.properties);
        MutationOperator mutationModule = new MutationOperator(this.rng, mutation);
        SelectionOperation selectionOperation = this.getSelectionOperation(this.properties, this.rng);
        SelectionScheme selectionScheme = new SelectionScheme(this.rng, selectionOperation);
        ReplacementOperation replacementOperation = new ReplacementOperation(this.properties);
        JoinOperator replacementStrategy = this.getJoinOperator(this.properties, this.rng, selectionScheme.getPopulation(), replacementOperation);
        SimplePipeline pipelineInit = new SimplePipeline();
        alg.setInitPipeline(pipelineInit);
        pipelineInit.addModule(this.initialiser);
        SimplePipeline pipelineLoop = new SimplePipeline();
        alg.setLoopPipeline(pipelineLoop);
        selectionScheme.setPopulation(this.initialiser.getPopulation());
        replacementStrategy.setPopulation(this.initialiser.getPopulation());
        crossoverModule.setPopulation(selectionScheme.getPopulation());
        mutationModule.setPopulation(selectionScheme.getPopulation());
        pipelineLoop.addModule(selectionScheme);
        pipelineLoop.addModule(crossoverModule);
        pipelineLoop.addModule(mutationModule);
        pipelineLoop.addModule(replacementStrategy);
        this.algorithm = alg;
    }

    public static void main(String[] args) {
        try {
            Tutorial5 mfs = new Tutorial5();
            if (mfs.commandLineArgs(args)) {
                mfs.setup(args);
                mfs.init();
                int its = mfs.run();
                System.out.println("Well done running: Tutorial5 for " + its + ", now look at Tutorial6");
            }
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
        }
    }
}

