/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Individuals.GEChromosome;
import Individuals.Phenotype;
import Mapper.DerivationNode;
import Mapper.GEGrammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Util.Constants;
import Util.Enums;
import Util.Random.MersenneTwisterFast;
import Util.Structures.IntIterator;
import Util.Structures.NimbleTree;
import Util.Structures.TreeNode;
import java.io.BufferedWriter;
import java.io.FileWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivationTree
extends NimbleTree<Symbol> {
    private final GEGrammar grammy;
    private final GEChromosome genny;
    private int wrapCount;
    private IntIterator genIter;
    private int geneCnt;

    @Override
    protected TreeNode<Symbol> newNode() {
        return new DerivationNode();
    }

    public DerivationTree(GEGrammar gram, GEChromosome gen) {
        this.getRoot().setData(gram.getStartSymbol());
        this.genny = gen;
        this.grammy = gram;
        this.genIter = this.genny.iterator();
        this.wrapCount = 1;
        this.geneCnt = 0;
    }

    public boolean buildDerivationTree() {
        assert (this.getCurrentNode() instanceof DerivationNode) : this.getCurrentNode().getClass().getName();
        DerivationNode t = (DerivationNode)this.getCurrentNode();
        this.grammy.findRule((Symbol)t.getData());
        Boolean validBuild = this.growNode(t);
        this.genny.setUsedGenes(this.geneCnt);
        return validBuild;
    }

    String getGECodonValue(String s, int codon) {
        String codon_value;
        int low = 0;
        int high = -1;
        int i = Constants.GE_CODON_VALUE_PARSING.length();
        char currentChar = s.charAt(i);
        while (currentChar != '>') {
            if (currentChar == '-') {
                currentChar = s.charAt(i++);
                while (currentChar >= '0' && currentChar <= '9') {
                    low = low * 10 + (currentChar - 48);
                    currentChar = s.charAt(i++);
                }
                continue;
            }
            if (currentChar == '+') {
                currentChar = s.charAt(i++);
                while (currentChar >= '0' && currentChar <= '9') {
                    if (high == -1) {
                        high = 0;
                    }
                    high = high * 10 + (currentChar - 48);
                    currentChar = s.charAt(i++);
                }
                continue;
            }
            currentChar = s.charAt(i++);
        }
        if (high == -1) {
            high = this.genny.getMaxCodonValue();
        }
        if (high == low) {
            codon_value = String.valueOf(low);
        } else {
            codon = codon % (high - low + 1) + low;
            codon_value = String.valueOf(codon);
        }
        return codon_value;
    }

    boolean growNode(DerivationNode t) {
        Symbol s = (Symbol)t.getData();
        if (this.getDepth() > this.grammy.getMaxDerivationTreeDepth()) {
            System.out.println("maxDerivationTreeDepth exceded:" + this.getDepth() + ">" + this.grammy.maxDerivationTreeDepth);
            return false;
        }
        if (this.geneCnt > this.genny.getMaxChromosomeLength()) {
            System.out.println("maxGEChromosomeLength exceded:" + this.geneCnt + ">" + this.genny.getMaxChromosomeLength());
            return false;
        }
        if (s.getType() == Enums.SymbolType.NTSymbol) {
            Rule r = this.grammy.findRule(s);
            int numProd = r.size();
            if (!this.genIter.hasNext()) {
                ++this.wrapCount;
                this.genIter = this.genny.iterator();
            }
            if (this.wrapCount <= this.grammy.getMaxWraps()) {
                Production p;
                int currentCodonValue;
                if (numProd > 1) {
                    currentCodonValue = this.genIter.next();
                    t.setCodonIndex(this.geneCnt, currentCodonValue % numProd);
                    ++this.geneCnt;
                    p = (Production)r.get(currentCodonValue % numProd);
                } else {
                    p = (Production)r.get(0);
                }
                for (Symbol newSym : p) {
                    if (newSym.getType() == Enums.SymbolType.NTSymbol && newSym.getSymbolString().startsWith(Constants.GE_CODON_VALUE_PARSING)) {
                        if (!this.genIter.hasNext()) {
                            this.genIter = this.genny.iterator();
                            ++this.wrapCount;
                        }
                        currentCodonValue = this.genIter.next();
                        String value = this.getGECodonValue(newSym.getSymbolString(), currentCodonValue);
                        newSym = new Symbol(value, Enums.SymbolType.TSymbol);
                    }
                    DerivationNode newTree = new DerivationNode(t, newSym);
                    t.add(newTree);
                    this.setCurrentLevel(this.getCurrentLevel() + 1);
                    if (this.getDepth() < this.getCurrentLevel()) {
                        this.setDepth(this.getCurrentLevel());
                    }
                    if (!this.growNode(newTree)) {
                        return false;
                    }
                    this.setCurrentLevel(this.getCurrentLevel() - 1);
                }
                return true;
            }
            return false;
        }
        this.grammy.getPhenotype().add(s);
        return true;
    }

    public int getWrapCount() {
        return this.wrapCount;
    }

    public int getGeneCnt() {
        return this.geneCnt;
    }

    public static void main(String[] args) {
        int length = 50000;
        int wraps = 20;
        GEGrammar g = new GEGrammar();
        g.setMaxWraps(wraps);
        g.setPhenotype(new Phenotype());
        GEChromosome gen = new GEChromosome(length);
        gen.setAll(DerivationTree.randomIntArray(length));
        g.setGenotype(gen);
        g.readBNFFile("/param/Grammar/mGGAGrammar128bit.bnf");
        String geCV = "<GECodonValue-1+10>";
        Boolean testGECV = false;
        for (int i = 0; i < 1; ++i) {
            System.out.println(i);
            g.getPhenotype().clear();
            DerivationTree dT = new DerivationTree(g, g.getGenotype());
            if (!dT.buildDerivationTree()) {
                System.out.println("Doh");
            }
            if (testGECV.booleanValue()) {
                int j = 0;
                while (j < 20) {
                    int gV = j++;
                    System.out.println("gV=" + gV + " GEC " + geCV + ":" + dT.getGECodonValue(geCV, gV));
                }
                testGECV = false;
            }
            try {
                FileWriter fw = new FileWriter(System.getProperty("user.home") + "/Desktop/phenotype.txt");
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(g.getPhenotype().getString());
                bw.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception, yeah, whatever");
            }
        }
    }

    private static int[] randomIntArray(int length) {
        int[] a = new int[length];
        MersenneTwisterFast m = new MersenneTwisterFast();
        for (int i = 0; i < length; ++i) {
            a[i] = Math.abs(m.nextInt());
        }
        return a;
    }
}

