/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Exceptions.BadParameterException;
import Individuals.GEChromosome;
import Individuals.Phenotype;
import Mapper.ContextFreeGrammar;
import Mapper.DerivationNode;
import Mapper.DerivationTree;
import Mapper.Production;
import Mapper.Rule;
import Parameter.ParameterI;
import Util.Constants;
import java.io.File;
import java.util.Properties;
import java.util.Stack;

public class GEGrammar
extends ContextFreeGrammar
implements ParameterI {
    private GEChromosome genotype;
    private Phenotype phenotype;
    private int maxWraps;
    private int usedWraps;
    private int usedCodons;
    private String name;
    int maxDerivationTreeDepth;
    int maxCurrentTreeDepth;

    public GEGrammar() {
        this.maxWraps = 1;
    }

    public GEGrammar(String file) {
        this.readBNFFile(file);
        this.maxWraps = 1;
    }

    public GEGrammar(Properties p) {
        this.setProperties(p);
    }

    public GEGrammar(GEGrammar copy) {
        super(copy);
        this.setMaxWraps(copy.getMaxWraps());
        this.maxWraps = copy.maxWraps;
        this.maxDerivationTreeDepth = copy.getMaxDerivationTreeDepth();
    }

    public void setProperties(Properties p) {
        int value;
        String key;
        String file = null;
        try {
            key = "grammar_file";
            file = p.getProperty(key);
            if (file == null) {
                throw new BadParameterException(key);
            }
        }
        catch (BadParameterException e) {
            System.out.println(e + " No default grammar");
        }
        File f = new File(file);
        if (!f.exists()) {
            this.readBNFFile(file);
        } else {
            this.readBNFFileFromFilesystem(file);
        }
        try {
            key = "max_wraps";
            value = Integer.parseInt(p.getProperty(key));
            if (value < 0) {
                throw new BadParameterException(key);
            }
        }
        catch (BadParameterException e) {
            value = 0;
            System.out.println(e + " default wraps:" + value);
        }
        this.maxWraps = value + 1;
        this.maxDerivationTreeDepth = Integer.parseInt(p.getProperty("max_dt_depth", Constants.DEFAULT_MAX_DERIVATION_TREE_DEPTH));
    }

    public boolean genotype2Phenotype() {
        return this.genotype2Phenotype(false);
    }

    public boolean phenotype2Genotype() {
        return true;
    }

    public void clear() {
        this.rules.clear();
        this.setStartSymbol(0);
        this.setValidGrammar(false);
    }

    public boolean genotype2Phenotype(boolean b) {
        boolean validMap;
        if (b) {
            this.phenotype.clear();
            DerivationTree dT = new DerivationTree(this, this.getGenotype());
            validMap = dT.buildDerivationTree();
            this.usedCodons = dT.getGeneCnt();
            this.usedWraps = dT.getWrapCount();
            this.maxCurrentTreeDepth = dT.getDepth();
            this.name = this.generateNameFromTree(dT);
            Object var3_2 = null;
        } else {
            validMap = true;
        }
        return validMap;
    }

    private String generateNameFromTree(DerivationTree tree) {
        StringBuilder builder = new StringBuilder();
        Stack<DerivationNode> nodeStack = new Stack<DerivationNode>();
        nodeStack.push((DerivationNode)tree.getRoot());
        while (!nodeStack.empty()) {
            DerivationNode nodes = (DerivationNode)nodeStack.pop();
            if (nodes != null) {
                if (nodes.getCodonIndex() != -1) {
                    builder.append(nodes.getCodonPick());
                }
                if (nodes.size() == 0) continue;
                builder.append('[');
                nodeStack.push(null);
                for (int i = nodes.size(); i > 0; --i) {
                    nodeStack.push((DerivationNode)nodes.get(i - 1));
                }
                continue;
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public int getMaxCurrentTreeDepth() {
        return this.maxCurrentTreeDepth;
    }

    public void setMaxCurrentTreeDepth(int maxCurrentTreeDepth) {
        this.maxCurrentTreeDepth = maxCurrentTreeDepth;
    }

    public int getMaxWraps() {
        return this.maxWraps;
    }

    public void setMaxWraps(int i) {
        this.maxWraps = i;
    }

    public void setGenotype(GEChromosome genotype) {
        this.genotype = genotype;
    }

    public void setPhenotype(Phenotype phenotype) {
        this.phenotype = phenotype;
    }

    public Phenotype getPhenotype() {
        return this.phenotype;
    }

    public GEChromosome getGenotype() {
        return this.genotype;
    }

    public void setPhenotype(Object p) {
        this.phenotype = (Phenotype)p;
    }

    public void setGenotype(Object g) {
        this.genotype = (GEChromosome)g;
    }

    public int getUsedCodons() {
        return this.usedCodons;
    }

    public int getUsedWraps() {
        return this.usedWraps;
    }

    public int getMaxDerivationTreeDepth() {
        return this.maxDerivationTreeDepth;
    }

    public void setMaxDerivationTreeDepth(int maxDerivationTreeDepth) {
        this.maxDerivationTreeDepth = maxDerivationTreeDepth;
    }

    public int getMaxChromosomeLengthByDepth() {
        int len = Integer.MAX_VALUE;
        if (this.maxDerivationTreeDepth < Integer.MAX_VALUE) {
            int maxNTProd = 0;
            for (Rule r : this.rules) {
                for (Production p : r) {
                    if (maxNTProd >= p.getNTSymbols()) continue;
                    maxNTProd = p.getNTSymbols();
                }
            }
            len = 0;
            for (int i = 0; i < this.maxDerivationTreeDepth; ++i) {
                len = (int)((double)len + Math.pow(maxNTProd, i));
            }
        }
        return len;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GEGrammar that = (GEGrammar)obj;
        return this.name == that.name || this.name != null && this.name.equals(that.name);
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return 0;
    }
}

