/*
 * Decompiled with CFR 0.152.
 */
package Operator;

import Individuals.Individual;
import Operator.Operations.CrossoverOperation;
import Operator.Operations.Operation;
import Operator.OperatorModule;
import Util.Random.RandomNumberGenerator;
import java.util.ArrayList;

public class CrossoverModule
extends OperatorModule {
    private CrossoverOperation op;
    private ArrayList<Individual> alI;

    public CrossoverModule(RandomNumberGenerator m, CrossoverOperation xOver) {
        super(m);
        this.op = xOver;
        this.alI = new ArrayList(2);
    }

    public void perform() {
        Individual i2;
        Individual i1;
        int i;
        int length = this.population.size() - this.population.size() % 2;
        for (i = 0; i < length; i += 2) {
            this.alI.clear();
            i1 = this.population.get(i);
            i2 = this.population.get(i + 1);
            this.alI.add(i1);
            this.alI.add(i2);
            this.op.doOperation(this.alI);
        }
        if (this.population.size() % 2 != 0) {
            i = this.population.size() - 1;
            i1 = this.population.get(i);
            i2 = this.getRandomNotThis(this.population.get(i));
            this.alI.add(i1);
            this.alI.add(i2);
            this.op.doOperation(this.alI);
        }
    }

    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation op) {
        this.op = (CrossoverOperation)op;
    }

    Individual getRandomNotThis(Individual me) {
        this.population.remove(me);
        Individual notMe = this.population.get(this.rng.nextInt(this.population.size()));
        this.population.add(me);
        return notMe;
    }
}

