/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Exceptions.InitializationException;
import Individuals.FitnessPackage.BasicFitness;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.GEGrammar;
import Mapper.Production;
import Mapper.Rule;
import Mapper.Symbol;
import Operator.Operations.CreationOperation;
import Util.Constants;
import Util.Enums;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import Util.Structures.NimbleTree;
import Util.Structures.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrowInitialiser
implements CreationOperation,
Stochastic {
    protected Genotype genotype;
    protected GEChromosome chromosome;
    protected RandomNumberGenerator rng;
    protected int maxDepth;
    protected int minDepth;
    protected GEGrammar grammar;
    protected int initChromSize;
    protected int extraCodons;

    public GrowInitialiser(RandomNumberGenerator rng, GEGrammar gegrammar, int maxDepth) {
        this.grammar = gegrammar;
        this.maxDepth = maxDepth;
        this.minDepth = 0;
        this.initChromSize = 100;
        this.rng = rng;
        this.extraCodons = 0;
    }

    public GrowInitialiser(RandomNumberGenerator rng, GEGrammar gegrammar, Properties p) {
        this.grammar = gegrammar;
        this.setProperties(p);
        this.minDepth = 0;
        this.rng = rng;
        this.extraCodons = 0;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setProperties(Properties p) {
        int value;
        try {
            String key = "max_depth";
            value = Integer.parseInt(p.getProperty(key));
            if (value < 1) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = 10;
            System.out.println(e + " using default: " + value);
        }
        this.maxDepth = value;
        String std = "10";
        String key = "initial_chromosome_size";
        try {
            value = Integer.parseInt(p.getProperty(key, std));
            if (value < 1) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = Integer.parseInt(std);
            System.out.println(e + " for " + key + " using default: " + value);
        }
        this.initChromSize = value;
    }

    @Override
    public Individual createIndividual() {
        GEGrammar gram = new GEGrammar(this.grammar);
        Phenotype phenotype = new Phenotype();
        int[] codons = new int[this.initChromSize];
        GEChromosome chrom = new GEChromosome(this.initChromSize, codons);
        if (gram.getMaxDerivationTreeDepth() < this.maxDepth) {
            gram.setMaxDerivationTreeDepth(this.maxDepth);
        }
        chrom.setMaxChromosomeLength(gram.getMaxChromosomeLengthByDepth());
        Genotype genotype = new Genotype(1, chrom);
        BasicFitness fitness = new BasicFitness();
        return new GEIndividual(gram, phenotype, genotype, fitness);
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public void setMinDepth(int minDepth) {
        this.minDepth = minDepth;
    }

    public void setMaxDepth(int i) {
        this.maxDepth = i;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public void doOperation(Individual operand) {
        GEIndividual ind = (GEIndividual)operand;
        ind.setGenotype(this.getGenotype(((GEChromosome)ind.getGenotype().get(0)).getMaxChromosomeLength()));
    }

    @Override
    public void doOperation(List<Individual> operands) {
    }

    public Genotype getGenotype(int maxLength) {
        this.genotype = new Genotype();
        this.chromosome = new GEChromosome(this.initChromSize);
        this.chromosome.setMaxChromosomeLength(maxLength);
        this.genotype.add(this.chromosome);
        NimbleTree<Symbol> dt = new NimbleTree<Symbol>();
        TreeNode<Symbol> tn = new TreeNode<Symbol>();
        tn.setData(this.grammar.getStartSymbol());
        dt.populateStack();
        dt.setRoot(tn);
        dt.setCurrentNode(dt.getRoot());
        this.grow(dt);
        if (this.extraCodons > 0) {
            for (int i = 0; i < this.extraCodons; ++i) {
                this.chromosome.add(this.rng.nextInt(Integer.MAX_VALUE));
            }
        }
        return this.genotype;
    }

    public boolean grow(NimbleTree<Symbol> dt) {
        ArrayList<Integer> possibleRules = new ArrayList<Integer>();
        try {
            if (dt.getCurrentNode().getData().getType() == Enums.SymbolType.TSymbol) {
                if (dt.getCurrentNode().getData().getSymbolString().contains("BRR")) {
                    ++this.extraCodons;
                }
                return true;
            }
            if (dt.getCurrentLevel() > this.maxDepth) {
                System.out.println("Too deep:" + dt.getCurrentLevel() + ">" + this.maxDepth);
                return false;
            }
            Rule rule = this.grammar.findRule(dt.getCurrentNode().getData());
            if (rule != null) {
                int tmp;
                int diff;
                Production prod;
                Iterator prodIt = rule.iterator();
                possibleRules.clear();
                int ii = 0;
                while (prodIt.hasNext()) {
                    prod = (Production)prodIt.next();
                    if (dt.getCurrentLevel() + prod.getMinimumDepth() <= this.maxDepth) {
                        possibleRules.add(ii);
                    }
                    ++ii;
                }
                if (possibleRules.isEmpty()) {
                    return false;
                }
                int prodVal = this.rng.nextInt(possibleRules.size());
                int modVal = (Integer)possibleRules.get(prodVal);
                int tmp1 = this.rng.nextInt(Integer.MAX_VALUE - rule.size());
                int mod = tmp1 % rule.size();
                if (mod > modVal) {
                    diff = mod - modVal;
                    tmp = tmp1 - diff;
                } else {
                    diff = modVal - mod;
                    tmp = tmp1 + diff;
                }
                int newMod = tmp % rule.size();
                if (newMod != modVal) {
                    System.out.println("modVal:" + modVal + " tmp1:" + tmp1 + " mod:" + mod + " tmp:" + tmp + " rule.size():" + rule.size() + " newMod:" + newMod);
                }
                if (rule.size() > 1) {
                    this.chromosome.add(tmp);
                    prod = (Production)rule.get((Integer)possibleRules.get(prodVal));
                } else {
                    prod = (Production)rule.get(0);
                }
                boolean result = true;
                int newMaxDepth = dt.getDepth();
                Iterator symIt = prod.iterator();
                while (symIt.hasNext() && result) {
                    Symbol symbol = (Symbol)symIt.next();
                    dt.addChild(symbol);
                    dt.setCurrentNode(dt.getCurrentNode().getEnd());
                    dt.setCurrentLevel(dt.getCurrentLevel() + 1);
                    result = this.grow(dt);
                    dt.setCurrentLevel(dt.getCurrentLevel() - 1);
                    if (newMaxDepth >= dt.getDepth()) continue;
                    newMaxDepth = dt.getDepth();
                }
                this.chromosome.setValid(result);
                dt.setDepth(newMaxDepth);
                return result;
            }
            if (!this.checkGECodonValue(dt)) {
                throw new InitializationException("Non-existent rule, maybe GECODON not yet impelemnted. Could not find" + dt.getCurrentNode().getData().getSymbolString());
            }
            return true;
        }
        catch (InitializationException e) {
            System.out.println(e);
            e.printStackTrace();
            return false;
        }
    }

    protected boolean checkGECodonValue(NimbleTree<Symbol> dt) {
        boolean ret = false;
        if (dt.getCurrentNode().getData().getSymbolString().contains(Constants.GE_CODON_VALUE)) {
            this.chromosome.add(this.rng.nextInt(Integer.MAX_VALUE));
            ret = true;
        }
        return ret;
    }
}

