/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Individuals.FitnessPackage.BasicFitness;
import Individuals.GEChromosome;
import Individuals.GEIndividual;
import Individuals.Genotype;
import Individuals.Individual;
import Individuals.Phenotype;
import Mapper.GEGrammar;
import Operator.Operations.SelectionOperation;
import Util.Random.MersenneTwisterFast;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouletteWheelFitProp
extends SelectionOperation
implements Stochastic {
    protected RandomNumberGenerator rng;
    protected double minFit;
    protected double sumFit;
    protected double[] accProbs;

    public RouletteWheelFitProp(int size, RandomNumberGenerator rng) {
        super(size);
        this.rng = rng;
    }

    public RouletteWheelFitProp() {
    }

    @Override
    public void setProperties(Properties p) {
        super.setProperties(p);
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        this.rankPopulation(operands);
        this.calculateFitnessSum(operands);
        this.calculateAccumulatedFitnessProbabilities(operands);
        this.spinRoulette(operands);
    }

    public void rankPopulation(List<Individual> operands) {
        Collections.sort(operands);
    }

    private void spinRoulette(List<Individual> operands) {
        this.selectedPopulation.clear();
        while (this.selectedPopulation.size() < super.getSize()) {
            int cnt;
            double prob = this.rng.nextDouble();
            for (cnt = 0; cnt < operands.size() && this.accProbs[cnt] < prob; ++cnt) {
            }
            if (cnt >= operands.size()) {
                cnt = operands.size() - 1;
            }
            Individual selected = operands.get(cnt);
            this.selectedPopulation.add(selected.clone());
        }
    }

    private void calculateAccumulatedFitnessProbabilities(List<Individual> operands) {
        double tmp;
        int cnt;
        if (this.sumFit == 0.0) {
            return;
        }
        this.accProbs = new double[operands.size()];
        double[] tmpA = new double[this.accProbs.length];
        double tmpSum = 0.0;
        for (cnt = 0; cnt < operands.size(); ++cnt) {
            tmp = operands.get(cnt).getFitness().getDouble();
            tmpA[cnt] = tmp = this.sumFit - tmp;
            tmpSum += tmp;
        }
        this.sumFit = tmpSum;
        for (cnt = 0; cnt < operands.size(); ++cnt) {
            tmp = tmpA[cnt];
            this.accProbs[cnt] = cnt > 0 ? this.accProbs[cnt - 1] + tmp : (tmp /= this.sumFit);
            if (!(this.accProbs[cnt] > 1.0)) continue;
            this.accProbs[cnt] = 1.0;
        }
    }

    private void calculateFitnessSum(List<Individual> c) {
        double sum = 0.0;
        Iterator<Individual> itI = c.iterator();
        this.minFit = Double.MAX_VALUE;
        while (itI.hasNext()) {
            double tmp = itI.next().getFitness().getDouble();
            sum += tmp;
            if (!(this.minFit < tmp)) continue;
            this.minFit = tmp;
        }
        this.sumFit = sum;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    public static void main(String[] args) {
        int runs = 1;
        ArrayList<Double> aL = new ArrayList<Double>(runs * 2);
        for (int ii = 0; ii < runs; ++ii) {
            int size = 2;
            MersenneTwisterFast rng = new MersenneTwisterFast();
            RouletteWheelFitProp rws = new RouletteWheelFitProp(size, rng);
            int popSize = 5;
            ArrayList<Individual> alI = new ArrayList<Individual>(popSize);
            String grammarFile = System.getProperty("user.dir") + "/param/Grammar/sf_grammar.bnf";
            GEGrammar gram = new GEGrammar(grammarFile);
            int maxChromSize = 10000;
            Phenotype phenotype = new Phenotype();
            Genotype genotype = new Genotype(1);
            GEChromosome chrom = new GEChromosome(maxChromSize);
            int[] codons = new int[maxChromSize];
            chrom.setAll(codons);
            genotype.add(chrom);
            gram.setPhenotype(phenotype);
            for (int i = 1; i < popSize; ++i) {
                GEIndividual ind = new GEIndividual();
                BasicFitness bf = new BasicFitness(i, ind);
                ind.setFitness(bf);
                ind.setMapper(gram);
                ind.setGenotype(genotype);
                ind.setPhenotype(phenotype);
                alI.add(ind);
            }
            rws.doOperation(alI);
            for (int k = 0; k < rws.selectedPopulation.size(); ++k) {
                aL.add(rws.selectedPopulation.get(k).getFitness().getDouble());
            }
            rws.selectedPopulation.clear();
        }
        StringBuffer s = new StringBuffer();
        for (Double anAL : aL) {
            s.append(anAL);
            s.append(" ");
        }
        s.append("\n");
        System.out.println(s.toString());
    }
}

