/*
 * Decompiled with CFR 0.152.
 */
package Operator.Operations;

import Exceptions.BadParameterException;
import Individuals.FitnessPackage.Fitness;
import Individuals.Individual;
import Operator.Operations.SelectionOperation;
import Util.Random.RandomNumberGenerator;
import Util.Random.Stochastic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TournamentSelect
extends SelectionOperation
implements Stochastic {
    protected RandomNumberGenerator rng;
    protected int tournamentSize;
    protected double pressureModifier;
    protected ArrayList<Fitness> tour;

    public TournamentSelect(int size, int tourSize, RandomNumberGenerator rand) {
        super(size);
        this.rng = rand;
        this.tournamentSize = tourSize;
        this.tour = new ArrayList(tourSize);
    }

    public TournamentSelect(RandomNumberGenerator rand, Properties p) {
        super(p);
        this.setProperties(p);
        this.rng = rand;
        this.tour = new ArrayList(this.tournamentSize);
    }

    public TournamentSelect() {
        this.tour = new ArrayList(this.tournamentSize);
    }

    @Override
    public void setProperties(Properties p) {
        int value;
        super.setProperties(p);
        try {
            String key = "tournament_size";
            value = Integer.parseInt(p.getProperty(key));
            if (value < 1) {
                throw new BadParameterException(key);
            }
        }
        catch (Exception e) {
            value = 3;
            System.out.println(e + " using default: " + value);
        }
        this.tournamentSize = value;
    }

    @Override
    public void doOperation(Individual operand) {
    }

    @Override
    public void doOperation(List<Individual> operands) {
        this.selectedPopulation.clear();
        while (this.selectedPopulation.size() < this.size) {
            this.getTour(operands);
            this.selectFromTour();
        }
    }

    public void getTour(List<Individual> operands) {
        this.tour.clear();
        for (int i = 0; i < this.tournamentSize; ++i) {
            int contestant = this.rng.nextInt(operands.size());
            this.tour.add(operands.get(contestant).getFitness());
        }
    }

    public void selectFromTour() {
        Collections.sort(this.tour);
        this.selectedPopulation.add(this.tour.get(0).getIndividual().clone());
    }

    @Override
    public void setRNG(RandomNumberGenerator m) {
        this.rng = m;
    }

    @Override
    public RandomNumberGenerator getRNG() {
        return this.rng;
    }
}

