/*
 * Decompiled with CFR 0.152.
 */
package Util.Statistics;

import Individuals.Chromosome;
import Individuals.FitnessPackage.Fitness;
import Individuals.GEIndividual;
import Individuals.Individual;
import Mapper.GEGrammar;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatCatcher {
    protected ArrayList<Double> meanFitness;
    protected ArrayList<Double> bestFitness;
    protected ArrayList<Double> varFitness;
    protected ArrayList<Integer> minLength;
    protected ArrayList<Integer> maxLength;
    protected ArrayList<Double> aveLength;
    protected ArrayList<Double> varLength;
    protected ArrayList<Double> meanUsedGenes;
    protected ArrayList<Double> meanDerivationTreeDepth;
    protected ArrayList<Long> time;
    protected ArrayList<Integer> invalids;
    protected ArrayList<ArrayList<Double>> allFitness;

    public StatCatcher() {
        this.meanFitness = new ArrayList();
        this.bestFitness = new ArrayList();
        this.varFitness = new ArrayList();
        this.aveLength = new ArrayList();
        this.varLength = new ArrayList();
        this.maxLength = new ArrayList();
        this.minLength = new ArrayList();
        this.meanUsedGenes = new ArrayList();
        this.meanDerivationTreeDepth = new ArrayList();
        this.time = new ArrayList();
        this.invalids = new ArrayList();
        this.allFitness = new ArrayList();
    }

    public StatCatcher(int gen) {
        this.meanFitness = new ArrayList(gen);
        this.bestFitness = new ArrayList(gen);
        this.varFitness = new ArrayList(gen);
        this.aveLength = new ArrayList(gen);
        this.varLength = new ArrayList(gen);
        this.maxLength = new ArrayList(gen);
        this.minLength = new ArrayList(gen);
        this.meanUsedGenes = new ArrayList(gen);
        this.meanDerivationTreeDepth = new ArrayList(gen);
        this.time = new ArrayList(gen);
        this.invalids = new ArrayList(gen);
        this.allFitness = new ArrayList(gen);
    }

    public void clear() {
        this.bestFitness = new ArrayList();
        this.meanFitness = new ArrayList();
        this.varFitness = new ArrayList();
        this.aveLength = new ArrayList();
        this.varLength = new ArrayList();
        this.maxLength = new ArrayList();
        this.minLength = new ArrayList();
        this.meanUsedGenes = new ArrayList();
        this.meanDerivationTreeDepth = new ArrayList();
        this.invalids = new ArrayList();
        this.allFitness = new ArrayList();
    }

    public void addTime(Long t) {
        this.time.add(t);
    }

    public void addStats(Fitness[] popFitness) {
        double temp;
        double total = 0.0;
        double bestSoFar = Double.MAX_VALUE;
        double n = 0.0;
        for (Fitness popFitnes : popFitness) {
            temp = popFitnes.getDouble();
            if (Double.isNaN(temp) || Double.isInfinite(temp) || temp == 1.0E8) continue;
            total += temp;
            n += 1.0;
            if (!(temp < bestSoFar)) continue;
            bestSoFar = temp;
        }
        if (Double.isInfinite(total)) {
            total = Double.MAX_VALUE;
        }
        double mean = total / n;
        this.meanFitness.add(mean);
        this.bestFitness.add(bestSoFar);
        total = 0.0;
        for (Fitness popFitnes : popFitness) {
            if (!popFitnes.getIndividual().isValid() || Double.isNaN(temp = popFitnes.getDouble()) || Double.isInfinite(temp) || temp == 1.0E8) continue;
            double x = temp - mean;
            total += x * x;
        }
        double variance = total / n;
        this.varFitness.add(variance);
    }

    public void addLength(ArrayList<Integer> popLength) {
        Iterator<Integer> iterD = popLength.iterator();
        int total = 0;
        int longest = Integer.MIN_VALUE;
        int shortest = Integer.MAX_VALUE;
        while (iterD.hasNext()) {
            int temp = iterD.next();
            total += temp;
            if (temp > longest) {
                longest = temp;
            }
            if (temp >= shortest) continue;
            shortest = temp;
        }
        int n = popLength.size();
        double mean = total / n;
        this.aveLength.add(mean);
        this.maxLength.add(longest);
        this.minLength.add(shortest);
        iterD = popLength.iterator();
        total = 0;
        while (iterD.hasNext()) {
            double x = (double)iterD.next().intValue() - mean;
            total = (int)((double)total + x * x);
        }
        double variance = total / n;
        this.varLength.add(variance);
    }

    public void addMeanDerivationTreeDepth(Fitness[] mG) {
        int total = 0;
        double n = 0.0;
        for (Fitness aMG : mG) {
            if (!aMG.getIndividual().isValid()) continue;
            GEIndividual ind = (GEIndividual)aMG.getIndividual();
            int temp = ((GEGrammar)ind.getMapper()).getMaxCurrentTreeDepth();
            total += temp;
            n += 1.0;
        }
        double mean = (double)total / n;
        this.meanDerivationTreeDepth.add(mean);
    }

    public void addMeanUsedGenes(Fitness[] mG) {
        int total = 0;
        double n = 0.0;
        for (Fitness aMG : mG) {
            if (!aMG.getIndividual().isValid()) continue;
            int temp = ((GEIndividual)aMG.getIndividual()).getUsedCodons();
            total += temp;
            n += 1.0;
        }
        double mean = (double)total / n;
        this.meanUsedGenes.add(mean);
    }

    public void addStatsPop(ArrayList<Individual> population) {
        Fitness[] fits = new Fitness[population.size()];
        Fitness[] usedGenes = new Fitness[population.size()];
        Iterator<Individual> iterP = population.iterator();
        ArrayList<Double> allFit = new ArrayList<Double>(population.size());
        ArrayList<Integer> allLength = new ArrayList<Integer>(population.size());
        int cnt = 0;
        int nr_invalids = 0;
        while (iterP.hasNext()) {
            Individual i = iterP.next();
            fits[cnt] = i.getFitness();
            usedGenes[cnt] = i.getFitness();
            allLength.add(((Chromosome)i.getGenotype().get(0)).getLength());
            if (!i.isValid()) {
                ++nr_invalids;
            }
            if (i.getAge() < 2) {
                allFit.add(i.getFitness().getDouble());
            }
            ++cnt;
        }
        this.allFitness.add(allFit);
        this.invalids.add(nr_invalids);
        this.addLength(allLength);
        this.addStats(fits);
        this.addMeanUsedGenes(usedGenes);
        this.addMeanDerivationTreeDepth(usedGenes);
    }

    public ArrayList<Double> getMeanDerivationTreeDepth() {
        return this.meanDerivationTreeDepth;
    }

    public ArrayList<ArrayList<Double>> getAllFitness() {
        return this.allFitness;
    }

    public ArrayList<Double> getMeanUsedGenes() {
        return this.meanUsedGenes;
    }

    public double getCurrentMeanUsedGenes() {
        return this.meanUsedGenes.get(this.meanUsedGenes.size() - 1);
    }

    public double getCurrentMean() {
        return this.meanFitness.get(this.meanFitness.size() - 1);
    }

    public ArrayList<Integer> getInvalids() {
        return this.invalids;
    }

    public double getCurrentBestFitness() {
        return this.bestFitness.get(this.bestFitness.size() - 1);
    }

    public ArrayList<Double> getBestFitness() {
        return this.bestFitness;
    }

    public ArrayList<Double> getVarFitness() {
        return this.varFitness;
    }

    public ArrayList<Double> getMeanFitness() {
        return this.meanFitness;
    }

    public ArrayList<Double> getAveLength() {
        return this.aveLength;
    }

    public ArrayList<Integer> getMaxLength() {
        return this.maxLength;
    }

    public ArrayList<Integer> getMinLength() {
        return this.minLength;
    }

    public ArrayList<Double> getVarLength() {
        return this.varLength;
    }

    public ArrayList<Long> getTime() {
        return this.time;
    }
}

