/*
 * Decompiled with CFR 0.152.
 */
package Util.Structures;

import Util.Structures.TreeNode;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NimbleTree<E> {
    private TreeNode<E> root;
    private TreeNode<E> currentNode;
    private Stack<TreeNode<E>> freeNodes;
    private int nodeCount;
    private int depth;
    private int currentLevel;
    private int maxStackSize;

    public NimbleTree() {
        this.root = this.newNode();
        this.currentNode = this.root;
        this.nodeCount = 1;
        this.depth = 0;
        this.currentLevel = 0;
        this.freeNodes = new Stack();
        this.maxStackSize = 10;
    }

    public NimbleTree(NimbleTree<E> n) {
        this.root = n.root;
        this.currentNode = n.currentNode;
        this.nodeCount = n.nodeCount;
        this.freeNodes = new Stack();
        this.depth = n.depth;
        this.currentLevel = n.currentLevel;
    }

    protected TreeNode<E> newNode() {
        return new TreeNode();
    }

    public void setMaxStackSize(int i) {
        this.maxStackSize = i;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void populateStack() {
        for (int i = 0; i < this.maxStackSize; ++i) {
            TreeNode<E> tn = this.newNode();
            this.freeNodes.push(tn);
        }
    }

    public TreeNode<E> getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode<E> tn) {
        this.root = tn;
    }

    public TreeNode<E> getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(TreeNode<E> tn) {
        this.currentNode = tn;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(int i) {
        this.nodeCount = i;
    }

    public void setDepth(int i) {
        this.depth = i;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(int i) {
        this.currentLevel = i;
    }

    public void addChild(E data) {
        if (!this.freeNodes.empty()) {
            TreeNode<E> n = this.freeNodes.pop();
            n.setData(data);
            n.setParent(this.currentNode);
            n.clear();
            this.setDepth(this.depth + 1);
            this.currentNode.add(n);
            ++this.nodeCount;
        } else {
            this.populateStack();
            this.addChild(data);
        }
    }

    public String toString() {
        String s = "";
        s = s + this.root.toString();
        return s;
    }
}

