/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine;

import com.rie.rieps.engine.DeviceParameter;
import com.rie.rieps.engine.Job;
import com.rie.rieps.engine.Page;
import com.rie.rieps.engine.factories.Factory;
import com.rie.rieps.exception.RiepsException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Document {
    private boolean openned = false;
    private boolean closed = false;
    private Job ownerJob;
    private int nbPages;
    private Map deviceParameters = new HashMap();
    private int currentPageNumber = 0;
    private float pageHeight = 0.0f;
    private float pageWidth = 0.0f;

    Document(Job owner, int nbPages, float ph, float pw) {
        this.ownerJob = owner;
        this.nbPages = nbPages;
        this.pageHeight = ph;
        this.pageWidth = pw;
        this.deviceParameters.put(DeviceParameter.PAGE_SIZE, new float[]{pw, ph});
    }

    public Job getOwnerJob() {
        return this.ownerJob;
    }

    public synchronized void open() throws RiepsException, IOException {
        if (this.isOpenned()) {
            return;
        }
        this.openned = true;
        this.getOwnerJob().writeToOutput(this.getOwnerJob().getFactory().getBeginJob(this.nbPages, this.pageWidth, this.pageHeight));
    }

    public synchronized boolean isOpenned() {
        return this.openned;
    }

    public synchronized void close() throws RiepsException, IOException {
        if (!this.isOpenned()) {
            return;
        }
        this.getOwnerJob().writeToOutput(this.getOwnerJob().getFactory().getEndJob());
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    Factory getFactory() {
        return this.getOwnerJob().getFactory();
    }

    public Page createPage() {
        Page p = new Page(this, this.pageHeight);
        p.setDeviceParameter(this.deviceParameters);
        return p;
    }

    public void setDeviceParameter(DeviceParameter param, Object value) {
        this.deviceParameters.put(param, value);
    }

    public synchronized void showPage(Page page) throws IOException, RiepsException {
        ++this.currentPageNumber;
        StringBuffer sb = this.getFactory().showPage(page, this.currentPageNumber, this.nbPages);
        this.getOwnerJob().writeToOutput(sb);
    }
}

