/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine;

import com.rie.rieps.engine.Document;
import com.rie.rieps.engine.factories.Factory;
import com.rie.rieps.engine.factories.PSFactory;
import com.rie.rieps.engine.fonts.PSFont;
import com.rie.rieps.engine.fonts.PSFontFile;
import com.rie.rieps.engine.fonts.PSFontFinder;
import com.rie.rieps.exception.RiepsException;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Job {
    private Factory factory;
    private OutputStream os;
    private String outputCharset = null;
    private List psFontFile = new ArrayList();
    private float pageHeight = 0.0f;
    private float pageWidth = 0.0f;
    private boolean openned = false;
    private boolean closed = false;
    private PSFontFinder psff;

    public static Job createJob(OutputStream os, Factory factory, float pageWidth, float pageHeight) {
        return new Job(os, factory, pageWidth, pageHeight);
    }

    public static Job createPSTopLeftOriginJob(OutputStream os, float pageWidth, float pageHeight) {
        PSFactory psfact = new PSFactory();
        return Job.createJob(os, psfact, pageWidth, pageHeight);
    }

    public synchronized void open() throws RiepsException {
        if (this.isClosed()) {
            throw new RiepsException("This job has already been closed.");
        }
        if (this.isOpenned()) {
            return;
        }
        this.openned = true;
    }

    public synchronized void close() throws RiepsException {
        if (!this.isOpenned()) {
            throw new RiepsException("You can't close a job which hasn't been openned.");
        }
        this.openned = false;
        this.closed = true;
    }

    public void setAvailableDeviceFont(String[] deviceFnt) {
        this.psff.setAvailableDeviceFont(deviceFnt);
    }

    public void addAwtPSFontMappingPropertiesFile(File f) throws IOException {
        this.psff.addMappingFile(f);
    }

    public void askForUnmappedAWTFont(boolean ask) {
        this.psff.askForUnkownAWTFont(ask);
    }

    public boolean askForUnmappedAWTFont() {
        return this.psff.askForUnkownAWTFont();
    }

    public void echoFontMapping(boolean b) {
        this.psff.setEchoMapping(b);
    }

    public PSFont getPSFontFromAWT(Font fnt) {
        return this.psff.searchPSFont(fnt);
    }

    Factory getFactory() {
        return this.factory;
    }

    private Job(OutputStream os, Factory factory, float pageWidth, float pageHeight) {
        this.factory = factory;
        this.os = os;
        this.psff = new PSFontFinder();
        this.pageHeight = pageHeight;
        this.pageWidth = pageWidth;
    }

    private OutputStream getOutputStream() {
        return this.os;
    }

    public void setOutputCharset(String charset) {
        this.outputCharset = charset;
    }

    public String getOutputCharset() {
        return this.outputCharset;
    }

    public Document createDocument(int nbPages) throws RiepsException {
        if (!this.isOpenned()) {
            throw new RiepsException("You have to open Job before create a document.");
        }
        return new Document(this, nbPages, this.pageHeight, this.pageWidth);
    }

    public void addPSFontFile(PSFontFile psff) {
        this.psFontFile.add(psff);
    }

    void writeToOutput(StringBuffer sb) throws IOException, RiepsException {
        if (!this.isOpenned()) {
            throw new RiepsException("You have to open Job before write to the output stream.");
        }
        this.getOutputStream().write(this.outputCharset == null ? sb.toString().getBytes() : sb.toString().getBytes(this.getOutputCharset()));
    }

    private boolean isOpenned() {
        return this.openned;
    }

    private boolean isClosed() {
        return this.closed;
    }
}

