/*
 * Decompiled with CFR 0.152.
 */
package com.rie.rieps.engine;

import com.rie.rieps.engine.color.Color;
import com.rie.rieps.engine.color.Gray;

public class LineFormat {
    public static final LineFormat DEFAULT = new LineFormat();
    private float width;
    private int[] dash;
    private int dashOffset;
    private Color color;

    public LineFormat() {
        this.width = 1.0f;
        this.dash = new int[0];
        this.dashOffset = 0;
        this.color = Gray.BLACK;
    }

    public LineFormat(LineFormat lf) {
        this.width = 1.0f;
        this.dash = new int[0];
        this.dashOffset = 0;
        this.color = Gray.BLACK;
        this.width = lf.getWidth();
        this.dash = lf.getDashPattern();
        this.dashOffset = lf.getDashOffset();
        this.color = lf.getColor();
    }

    public LineFormat(float width, int dashLength, Color c) {
        int[] nArray;
        if (dashLength == 0) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = dashLength;
        }
        this(width, nArray, 0, c);
    }

    public LineFormat(float width, int[] pattern, int offset, Color c) {
        this.width = 1.0f;
        this.dash = new int[0];
        this.dashOffset = 0;
        this.color = Gray.BLACK;
        this.rewidth(width);
        this.redash(pattern, offset);
        this.recolor(c);
    }

    public LineFormat(float width, Color c) {
        this(width, new int[0], 0, c);
    }

    public LineFormat setWidth(float width) {
        LineFormat lf = new LineFormat(this);
        lf.rewidth(width);
        return lf;
    }

    private void rewidth(float width) {
        this.width = width;
    }

    public float getWidth() {
        return this.width;
    }

    public LineFormat setDash(int length) {
        LineFormat lf = new LineFormat(this);
        int[] d = new int[]{length};
        lf.redash(d, 0);
        return lf;
    }

    public LineFormat setDash(int[] pattern, int offset) {
        LineFormat lf = new LineFormat(this);
        lf.redash(pattern, offset);
        return lf;
    }

    private void redash(int[] pattern, int offset) {
        this.dash = new int[pattern.length];
        System.arraycopy(pattern, 0, this.dash, 0, pattern.length);
        this.dashOffset = offset;
    }

    public int[] getDashPattern() {
        int[] tmp = new int[this.dash.length];
        System.arraycopy(this.dash, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public int getDashOffset() {
        return this.dashOffset;
    }

    public Color getColor() {
        return this.color;
    }

    public LineFormat setColor(Color c) {
        LineFormat lf = new LineFormat(this);
        lf.recolor(c);
        return lf;
    }

    private void recolor(Color c) {
        this.color = c;
    }
}

