/*
 * Decompiled with CFR 0.152.
 */
package ext.number;

import ext.number.Value;

public class ValReal
extends Value {
    public static final ValReal MIN_VALUE = new ValReal(Double.MIN_VALUE);
    public static final ValReal MAX_VALUE = new ValReal(Double.MAX_VALUE);
    public static final ValReal ZERO = new ValReal(0.0);

    public ValReal(double value) {
        this.value = value;
    }

    public ValReal(ValReal src) {
        this(src.value.doubleValue());
    }

    public ValReal add(Value right) {
        return new ValReal(this.value.doubleValue() + right.value.doubleValue());
    }

    public ValReal substract(Value right) {
        return new ValReal(this.value.doubleValue() - right.value.doubleValue());
    }

    public int compareTo(Value right) {
        if (this.value.doubleValue() < right.value.doubleValue()) {
            return -1;
        }
        if (this.value.doubleValue() > right.value.doubleValue()) {
            return 1;
        }
        return 0;
    }

    public ValReal rand() {
        return new ValReal(randomGenerator.nextDouble());
    }

    public ValReal rand(Value upperBound) {
        return new ValReal(this.value.doubleValue() + (upperBound.value.doubleValue() - this.value.doubleValue()) * randomGenerator.nextDouble());
    }

    public boolean equals(Object right) {
        return right instanceof Value && this.value.doubleValue() == ((Value)right).value.doubleValue();
    }

    public ValReal clone() {
        return new ValReal(this);
    }

    public String toString() {
        return "" + this.value;
    }

    public ValReal opposite() {
        return new ValReal(-this.value.intValue());
    }

    public ValReal multiply(Number right) {
        return new ValReal(this.value.doubleValue() * right.doubleValue());
    }
}

