/*
 * Decompiled with CFR 0.152.
 */
package jeco.dmm.reliableDMM;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBank {
    protected int numOfBank;
    protected MemoryBank next;
    protected MemoryBank prev;
    protected BufferedWriter writer;
    protected ArrayList<Integer> accessesList;

    public MemoryBank(int numOfBank, String resultProfilePath) throws Exception {
        this.numOfBank = numOfBank;
        this.next = null;
        this.prev = null;
        StringTokenizer tokens = new StringTokenizer(resultProfilePath, ".");
        String finalPath = tokens.nextToken() + numOfBank + ".";
        while (tokens.hasMoreTokens()) {
            finalPath = finalPath + tokens.nextToken();
        }
        this.writer = new BufferedWriter(new FileWriter(new File(finalPath)));
        this.accessesList = new ArrayList();
    }

    public int getNumOfBank() {
        return this.numOfBank;
    }

    public void setNumOfBank(int numOfBank) {
        this.numOfBank = numOfBank;
    }

    public MemoryBank getNext() {
        return this.next;
    }

    public void setNext(MemoryBank next) {
        this.next = next;
    }

    public MemoryBank getPrev() {
        return this.prev;
    }

    public void setPrev(MemoryBank prev) {
        this.prev = prev;
    }

    public void writeFile(String line) throws Exception {
        this.writer.write(line + "\n");
    }

    public void closeFile() throws Exception {
        this.writer.close();
    }

    public void addAccess(int accesses) {
        this.accessesList.add(accesses);
    }

    public ArrayList<Integer> getAccessesList() {
        return this.accessesList;
    }
}

